/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.deployer;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb.deployers.EjbDeployment;
import org.jboss.ejb.deployers.MergedJBossMetaDataDeployer;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.javaee.spec.PortComponent;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.wsf.container.jboss50.deployer.AbstractWebServiceDeployer;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeclaration;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeployment;
import org.jboss.wsf.spi.metadata.j2ee.PortComponentMD;
import org.jboss.wsf.spi.metadata.j2ee.PortComponentSpec;

public class WebServiceDeployerEJB
extends AbstractWebServiceDeployer {
    private static final Logger log = Logger.getLogger(WebServiceDeployerEJB.class);

    public WebServiceDeployerEJB() {
        this.addInput(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
        this.addInput(EjbDeployment.class);
        this.addOutput(JBossWebMetaData.class);
        this.addOutput(WebServiceDeployment.class);
    }

    public void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        JBossMetaData beans = (JBossMetaData)unit.getAttachment(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
        if (beans != null) {
            WebServiceDeploymentAdapter wsDeployment = new WebServiceDeploymentAdapter();
            for (JBossEnterpriseBeanMetaData ejb : beans.getEnterpriseBeans()) {
                if (ejb.getEjbClass() != null) {
                    wsDeployment.getEndpoints().add(new WebServiceDeclarationAdapter(ejb, unit.getClassLoader()));
                    continue;
                }
                log.warn((Object)("Ingore ejb deployment with null classname: " + ejb));
            }
            unit.addAttachment(WebServiceDeployment.class, (Object)wsDeployment);
            super.internalDeploy(unit);
        }
    }

    public void internalUndeploy(DeploymentUnit unit) {
        super.internalUndeploy(unit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebServiceDeploymentAdapter
    implements WebServiceDeployment {
        private List<WebServiceDeclaration> endpoints = new ArrayList<WebServiceDeclaration>();

        private WebServiceDeploymentAdapter() {
        }

        public List<WebServiceDeclaration> getServiceEndpoints() {
            return this.endpoints;
        }

        public List<WebServiceDeclaration> getEndpoints() {
            return this.endpoints;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebServiceDeclarationAdapter
    implements WebServiceDeclaration {
        private JBossEnterpriseBeanMetaData ejbMetaData;
        private ClassLoader loader;

        public WebServiceDeclarationAdapter(JBossEnterpriseBeanMetaData ejbMetaData, ClassLoader loader) {
            this.ejbMetaData = ejbMetaData;
            this.loader = loader;
        }

        public String getContainerName() {
            return this.ejbMetaData.determineContainerName();
        }

        public String getComponentName() {
            return this.ejbMetaData.getName();
        }

        public String getComponentClassName() {
            return this.ejbMetaData.getEjbClass();
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotation) {
            PortComponent pc;
            Class bean = this.getComponentClass();
            PortComponentMD result = null;
            if (bean.isAnnotationPresent(annotation)) {
                result = (PortComponentMD)bean.getAnnotation(annotation);
            }
            if (PortComponentSpec.class.equals(annotation) && this.ejbMetaData instanceof JBossSessionBeanMetaData && (pc = ((JBossSessionBeanMetaData)this.ejbMetaData).getPortComponent()) != null) {
                PortComponentMD pcMetaData = new PortComponentMD();
                pcMetaData.setAuthMethod(pc.getAuthMethod());
                pcMetaData.setPortComponentName(pc.getPortComponentName());
                pcMetaData.setPortComponentURI(pc.getPortComponentURI());
                pcMetaData.setSecureWSDLAccess(pc.getSecureWSDLAccess());
                pcMetaData.setTransportGuarantee(pc.getTransportGuarantee());
                result = pcMetaData;
            }
            return (T)result;
        }

        private Class getComponentClass() {
            try {
                return this.loader.loadClass(this.getComponentClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to load component class " + this.getComponentClassName() + ". Loader:" + this.loader);
            }
        }
    }
}

