/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.http;

import java.util.Map;
import javax.management.MBeanServer;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.samples.http.ComplexObject;

public class WebInvocationHandler
implements ServerInvocationHandler {
    public static final String RESPONSE_VALUE = "This is the return to simple text based http invocation.";
    public static final ComplexObject OBJECT_RESPONSE_VALUE = new ComplexObject(5, "dub", false);
    public static final String HTML_PAGE_RESPONSE = "<html><head><title>Test HTML page</title></head><body><h1>HTTP/Servlet Test HTML page</h1><p>This is a simple page served for test.<p>Should show up in browser or via invoker client</body></html>";
    public static final String NULL_RETURN_PARAM = "return_null";
    public static final String OBJECT_RETURN_PARAM = "return_object";
    public static final String STRING_RETURN_PARAM = "return_string";

    public Object invoke(InvocationRequest invocation) throws Throwable {
        System.out.println("Invocation request from client is: " + invocation.getParameter());
        if (NULL_RETURN_PARAM.equals(invocation.getParameter())) {
            return null;
        }
        if (invocation.getParameter() instanceof ComplexObject) {
            return OBJECT_RESPONSE_VALUE;
        }
        if (STRING_RETURN_PARAM.equals(invocation.getParameter())) {
            Map responseMetadata = invocation.getReturnPayload();
            responseMetadata.put("ResponseCode", new Integer(207));
            responseMetadata.put("ResponseCodeMessage", "Custom response code and message from remoting server");
            return RESPONSE_VALUE;
        }
        return HTML_PAGE_RESPONSE;
    }

    public void addListener(InvokerCallbackHandler callbackHandler) {
    }

    public void removeListener(InvokerCallbackHandler callbackHandler) {
    }

    public void setMBeanServer(MBeanServer server) {
    }

    public void setInvoker(ServerInvoker invoker) {
    }
}

