/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.io.Serializable;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.DeleteException;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.SaveException;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import org.apache.juddi.IRegistry;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.assertion.PublisherAssertion;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.response.AssertionStatusItem;
import org.apache.juddi.datatype.response.AssertionStatusReport;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.datatype.response.BindingDetail;
import org.apache.juddi.datatype.response.BusinessDetail;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.ErrInfo;
import org.apache.juddi.datatype.response.PublisherAssertions;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.datatype.response.ServiceDetail;
import org.apache.juddi.datatype.response.TModelDetail;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.error.RegistryException;
import org.apache.log4j.Logger;
import org.apache.ws.scout.registry.BulkResponseImpl;
import org.apache.ws.scout.registry.ConnectionImpl;
import org.apache.ws.scout.registry.LifeCycleManagerImpl;
import org.apache.ws.scout.registry.infomodel.KeyImpl;
import org.apache.ws.scout.util.ScoutJaxrUddiHelper;

public class BusinessLifeCycleManagerImpl
extends LifeCycleManagerImpl
implements BusinessLifeCycleManager,
Serializable {
    private static final long serialVersionUID = 4662854497208312765L;
    private static Logger log = Logger.getLogger((Class)(class$org$apache$ws$scout$registry$BusinessLifeCycleManagerImpl == null ? (class$org$apache$ws$scout$registry$BusinessLifeCycleManagerImpl = BusinessLifeCycleManagerImpl.class$("org.apache.ws.scout.registry.BusinessLifeCycleManagerImpl")) : class$org$apache$ws$scout$registry$BusinessLifeCycleManagerImpl));
    static /* synthetic */ Class class$org$apache$ws$scout$registry$BusinessLifeCycleManagerImpl;

    public BusinessLifeCycleManagerImpl(RegistryService registry) {
        super(registry);
    }

    public BulkResponse deleteObjects(Collection keys, String objectType) throws JAXRException {
        BulkResponse bulk = null;
        if (objectType == "Association") {
            bulk = this.deleteAssociations(keys);
        } else if (objectType == "ClassificationScheme") {
            bulk = this.deleteClassificationSchemes(keys);
        } else if (objectType == "Concept") {
            bulk = this.deleteConcepts(keys);
        } else if (objectType == "Organization") {
            bulk = this.deleteOrganizations(keys);
        } else if (objectType == "Service") {
            bulk = this.deleteServices(keys);
        } else if (objectType == "ServiceBinding") {
            bulk = this.deleteServiceBindings(keys);
        } else {
            throw new JAXRException("Delete Operation for " + objectType + " not implemented by Scout");
        }
        return bulk;
    }

    public BulkResponse deleteAssociations(Collection associationKeys) throws JAXRException {
        return this.deleteOperation(associationKeys, "DELETE_ASSOCIATION");
    }

    public BulkResponse deleteClassificationSchemes(Collection schemeKeys) throws JAXRException {
        return this.deleteOperation(schemeKeys, "DELETE_CLASSIFICATIONSCHEME");
    }

    public BulkResponse deleteConcepts(Collection conceptKeys) throws JAXRException {
        return this.deleteOperation(conceptKeys, "DELETE_CONCEPT");
    }

    public BulkResponse deleteOrganizations(Collection orgkeys) throws JAXRException {
        return this.deleteOperation(orgkeys, "DELETE_ORG");
    }

    public BulkResponse deleteServiceBindings(Collection bindingKeys) throws JAXRException {
        return this.deleteOperation(bindingKeys, "DELETE_SERVICEBINDING");
    }

    public BulkResponse deleteServices(Collection serviceKeys) throws JAXRException {
        return this.deleteOperation(serviceKeys, "DELETE_SERVICE");
    }

    public BulkResponse saveObjects(Collection col) throws JAXRException {
        Iterator iter = col.iterator();
        ArrayList suc = new ArrayList();
        ArrayList exc = new ArrayList();
        while (iter.hasNext()) {
            javax.xml.registry.infomodel.RegistryObject reg = (javax.xml.registry.infomodel.RegistryObject)iter.next();
            BulkResponse br = null;
            ArrayList<javax.xml.registry.infomodel.RegistryObject> c = new ArrayList<javax.xml.registry.infomodel.RegistryObject>();
            c.add(reg);
            if (reg instanceof Association) {
                br = this.saveAssociations(c, true);
            } else if (reg instanceof ClassificationScheme) {
                br = this.saveClassificationSchemes(c);
            } else if (reg instanceof Concept) {
                br = this.saveConcepts(c);
            } else if (reg instanceof Organization) {
                br = this.saveOrganizations(c);
            } else if (reg instanceof Service) {
                br = this.saveServices(c);
            } else if (reg instanceof ServiceBinding) {
                br = this.saveServiceBindings(c);
            } else {
                throw new JAXRException("Delete Operation for " + reg.getClass() + " not implemented by Scout");
            }
            if (br.getCollection() != null) {
                suc.addAll(br.getCollection());
            }
            if (br.getExceptions() == null) continue;
            suc.addAll(br.getExceptions());
        }
        BulkResponseImpl bulk = new BulkResponseImpl();
        bulk.setStatus(0);
        bulk.setCollection(suc);
        bulk.setExceptions(exc);
        return bulk;
    }

    public BulkResponse saveAssociations(Collection asso, boolean replace) throws JAXRException {
        BulkResponseImpl bulk = new BulkResponseImpl();
        Vector<PublisherAssertion> svect = new Vector<PublisherAssertion>();
        ArrayList<String> coll = new ArrayList<String>();
        ArrayList<SaveException> exceptions = new ArrayList<SaveException>();
        Iterator iter = asso.iterator();
        while (iter.hasNext()) {
            try {
                PublisherAssertion pa = ScoutJaxrUddiHelper.getPubAssertionFromJAXRAssociation((Association)iter.next());
                svect.add(pa);
            }
            catch (ClassCastException ce) {
                throw new UnexpectedObjectException();
            }
        }
        PublisherAssertions bd = null;
        try {
            bd = (PublisherAssertions)this.executeOperation(svect, "SAVE_ASSOCIATION");
        }
        catch (RegistryException e) {
            exceptions.add(new SaveException(e.getLocalizedMessage()));
            bulk.setExceptions(exceptions);
            bulk.setStatus(2);
            return bulk;
        }
        if (bd != null) {
            Vector keyvect = bd.getPublisherAssertionVector();
            for (int i = 0; keyvect != null && i < keyvect.size(); ++i) {
                PublisherAssertion result = (PublisherAssertion)keyvect.elementAt(i);
                KeyedReference kr = result.getKeyedReference();
                coll.add(kr.getTModelKey());
            }
        }
        bulk.setCollection(coll);
        bulk.setExceptions(exceptions);
        return bulk;
    }

    public BulkResponse saveClassificationSchemes(Collection schemes) throws JAXRException {
        BulkResponseImpl bulk = new BulkResponseImpl();
        Vector entityvect = new Vector();
        ArrayList<KeyImpl> coll = new ArrayList<KeyImpl>();
        ArrayList<SaveException> exceptions = new ArrayList<SaveException>();
        Iterator iter = schemes.iterator();
        while (iter.hasNext()) {
            try {
                TModel en = ScoutJaxrUddiHelper.getTModelFromJAXRClassificationScheme((ClassificationScheme)iter.next());
                entityvect.add(en);
            }
            catch (ClassCastException ce) {
                throw new UnexpectedObjectException();
            }
        }
        log.debug((Object)("Method:save_classificationscheme: ENlength=" + entityvect.size()));
        TModelDetail td = null;
        try {
            td = (TModelDetail)this.executeOperation(entityvect, "SAVE_TMODEL");
        }
        catch (RegistryException e) {
            exceptions.add(new SaveException(e.getLocalizedMessage()));
            bulk.setStatus(2);
            return bulk;
        }
        entityvect = td.getTModelVector();
        log.debug((Object)("After Saving TModel. Obtained vector size:" + entityvect.size()));
        for (int i = 0; entityvect != null && i < entityvect.size(); ++i) {
            TModel tm = (TModel)entityvect.elementAt(i);
            coll.add(new KeyImpl(tm.getTModelKey()));
        }
        bulk.setCollection(coll);
        bulk.setExceptions(exceptions);
        return bulk;
    }

    public BulkResponse saveConcepts(Collection concepts) throws JAXRException {
        BulkResponseImpl bulk = new BulkResponseImpl();
        Vector entityvect = new Vector();
        ArrayList<KeyImpl> coll = new ArrayList<KeyImpl>();
        ArrayList<SaveException> exceptions = new ArrayList<SaveException>();
        Iterator iter = concepts.iterator();
        while (iter.hasNext()) {
            try {
                TModel en = ScoutJaxrUddiHelper.getTModelFromJAXRConcept((Concept)iter.next());
                entityvect.add(en);
            }
            catch (ClassCastException ce) {
                throw new UnexpectedObjectException();
            }
        }
        log.debug((Object)("Method:save_concept: ENlength=" + entityvect.size()));
        TModelDetail td = null;
        try {
            td = (TModelDetail)this.executeOperation(entityvect, "SAVE_TMODEL");
        }
        catch (RegistryException e) {
            exceptions.add(new SaveException(e.getLocalizedMessage()));
            bulk.setStatus(2);
            return bulk;
        }
        entityvect = td.getTModelVector();
        log.debug((Object)("After Saving TModel. Obtained vector size:" + entityvect.size()));
        for (int i = 0; entityvect != null && i < entityvect.size(); ++i) {
            TModel tm = (TModel)entityvect.elementAt(i);
            coll.add(new KeyImpl(tm.getTModelKey()));
        }
        bulk.setCollection(coll);
        bulk.setExceptions(exceptions);
        return bulk;
    }

    public BulkResponse saveOrganizations(Collection organizations) throws JAXRException {
        BulkResponseImpl bulk = new BulkResponseImpl();
        Vector entityvect = new Vector();
        ArrayList<KeyImpl> coll = new ArrayList<KeyImpl>();
        ArrayList<SaveException> exceptions = new ArrayList<SaveException>();
        Iterator iter = organizations.iterator();
        while (iter.hasNext()) {
            try {
                BusinessEntity en = ScoutJaxrUddiHelper.getBusinessEntityFromJAXROrg((Organization)iter.next());
                entityvect.add(en);
            }
            catch (ClassCastException ce) {
                throw new UnexpectedObjectException();
            }
        }
        log.debug((Object)("Method:save_business: ENlength=" + entityvect.size()));
        BusinessDetail bd = null;
        try {
            bd = (BusinessDetail)this.executeOperation(entityvect, "SAVE_ORG");
        }
        catch (RegistryException e) {
            exceptions.add(new SaveException(e.getLocalizedMessage()));
            bulk.setStatus(2);
            return bulk;
        }
        entityvect = bd.getBusinessEntityVector();
        log.debug((Object)("After Saving Business. Obtained vector size:" + entityvect.size()));
        for (int i = 0; entityvect != null && i < entityvect.size(); ++i) {
            BusinessEntity entity = (BusinessEntity)entityvect.elementAt(i);
            coll.add(new KeyImpl(entity.getBusinessKey()));
        }
        bulk.setCollection(coll);
        bulk.setExceptions(exceptions);
        return bulk;
    }

    public BulkResponse saveServiceBindings(Collection bindings) throws JAXRException {
        BulkResponseImpl bulk = new BulkResponseImpl();
        Vector sbvect = new Vector();
        ArrayList<KeyImpl> coll = new ArrayList<KeyImpl>();
        ArrayList<SaveException> exceptions = new ArrayList<SaveException>();
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            try {
                BindingTemplate bs = ScoutJaxrUddiHelper.getBindingTemplateFromJAXRSB((ServiceBinding)iter.next());
                sbvect.add(bs);
            }
            catch (ClassCastException ce) {
                throw new UnexpectedObjectException();
            }
        }
        BindingDetail bd = null;
        try {
            bd = (BindingDetail)this.executeOperation(sbvect, "SAVE_SERVICE_BINDING");
        }
        catch (RegistryException e) {
            exceptions.add(new SaveException(e.getLocalizedMessage()));
            bulk.setStatus(2);
            return bulk;
        }
        sbvect = bd.getBindingTemplateVector();
        for (int i = 0; sbvect != null && i < sbvect.size(); ++i) {
            BindingTemplate bt = (BindingTemplate)sbvect.elementAt(i);
            coll.add(new KeyImpl(bt.getBindingKey()));
        }
        bulk.setCollection(coll);
        bulk.setExceptions(exceptions);
        return bulk;
    }

    public BulkResponse saveServices(Collection services) throws JAXRException {
        BulkResponseImpl bulk = new BulkResponseImpl();
        Vector svect = new Vector();
        ArrayList<KeyImpl> coll = new ArrayList<KeyImpl>();
        ArrayList<SaveException> exceptions = new ArrayList<SaveException>();
        Iterator iter = services.iterator();
        while (iter.hasNext()) {
            try {
                BusinessService bs = ScoutJaxrUddiHelper.getBusinessServiceFromJAXRService((Service)iter.next());
                svect.add(bs);
            }
            catch (ClassCastException ce) {
                throw new UnexpectedObjectException();
            }
        }
        ServiceDetail sd = null;
        try {
            sd = (ServiceDetail)this.executeOperation(svect, "SAVE_SERVICE");
        }
        catch (RegistryException e) {
            exceptions.add(new SaveException(e.getLocalizedMessage()));
            bulk.setStatus(2);
            return bulk;
        }
        svect = sd.getBusinessServiceVector();
        for (int i = 0; svect != null && i < svect.size(); ++i) {
            BusinessService entity = (BusinessService)svect.elementAt(i);
            coll.add(new KeyImpl(entity.getServiceKey()));
        }
        bulk.setCollection(coll);
        bulk.setExceptions(exceptions);
        return bulk;
    }

    public void confirmAssociation(Association assoc) throws JAXRException, InvalidRequestException {
        ArrayList<Association> col = new ArrayList<Association>();
        col.add(assoc);
        BulkResponse br = this.saveAssociations(col, true);
        if (br.getExceptions() != null) {
            throw new JAXRException("Confiming the Association Failed");
        }
    }

    public void unConfirmAssociation(Association assoc) throws JAXRException, InvalidRequestException {
        ArrayList<Key> col = new ArrayList<Key>();
        col.add(assoc.getKey());
        BulkResponse br = this.deleteAssociations(col);
        if (br.getExceptions() != null) {
            throw new JAXRException("UnConfiming the Association Failed");
        }
    }

    protected RegistryObject executeOperation(Vector datavect, String op) throws RegistryException, JAXRException {
        PublisherAssertions regobj = null;
        IRegistry ireg = null;
        if (this.registry != null) {
            ireg = this.registry.getRegistry();
        }
        ConnectionImpl connection = this.registry.getConnection();
        AuthToken token = this.getAuthToken(connection, ireg);
        if (op.equalsIgnoreCase("SAVE_ASSOCIATION")) {
            regobj = ireg.setPublisherAssertions(token.getAuthInfo(), datavect);
        } else if (op.equalsIgnoreCase("SAVE_SERVICE")) {
            regobj = ireg.saveService(token.getAuthInfo(), datavect);
        } else if (op.equalsIgnoreCase("SAVE_SERVICE_BINDING")) {
            regobj = ireg.saveBinding(token.getAuthInfo(), datavect);
        } else if (op.equalsIgnoreCase("SAVE_ORG")) {
            regobj = ireg.saveBusiness(token.getAuthInfo(), datavect);
        } else if (op.equalsIgnoreCase("SAVE_TMODEL")) {
            regobj = ireg.saveTModel(token.getAuthInfo(), datavect);
        } else if (op.equalsIgnoreCase("DELETE_ORG")) {
            this.clearPublisherAssertions(token.getAuthInfo(), datavect, ireg);
            regobj = ireg.deleteBusiness(token.getAuthInfo(), datavect);
        } else if (op.equalsIgnoreCase("DELETE_SERVICE")) {
            regobj = ireg.deleteService(token.getAuthInfo(), datavect);
        } else if (op.equalsIgnoreCase("DELETE_SERVICEBINDING")) {
            regobj = ireg.deleteBinding(token.getAuthInfo(), datavect);
        } else if (op.equalsIgnoreCase("DELETE_CONCEPT")) {
            regobj = ireg.deleteTModel(token.getAuthInfo(), datavect);
        } else if (op.equalsIgnoreCase("DELETE_ASSOCIATION")) {
            int len = datavect.size();
            Vector<PublisherAssertion> pavect = new Vector<PublisherAssertion>(len);
            for (int i = 0; i < len; ++i) {
                String keystr = (String)datavect.elementAt(i);
                pavect.add(ScoutJaxrUddiHelper.getPubAssertionFromJAXRAssociationKey(keystr));
            }
            regobj = ireg.deletePublisherAssertions(token.getAuthInfo(), pavect);
        } else if (op.equalsIgnoreCase("DELETE_CLASSIFICATIONSCHEME")) {
            regobj = ireg.deleteTModel(token.getAuthInfo(), datavect);
        } else {
            throw new JAXRException("Unsupported operation:" + op);
        }
        return regobj;
    }

    private void clearPublisherAssertions(AuthInfo authinfo, Vector orgkeys, IRegistry ireg) {
        Vector<PublisherAssertion> pasvect = null;
        try {
            AssertionStatusItem asi;
            int i;
            AssertionStatusReport report = ireg.getAssertionStatusReport(authinfo, "status:complete");
            Vector v = report.getAssertionStatusItemVector();
            int len = v != null ? v.size() : 0;
            for (i = 0; i < len; ++i) {
                asi = (AssertionStatusItem)v.elementAt(i);
                if (pasvect == null) {
                    pasvect = new Vector<PublisherAssertion>(len);
                }
                pasvect.add(this.getPublisherAssertion(asi));
            }
            report = ireg.getAssertionStatusReport(authinfo, "status:toKey_incomplete");
            v = report.getAssertionStatusItemVector();
            len = v != null ? v.size() : 0;
            for (i = 0; i < len; ++i) {
                asi = (AssertionStatusItem)v.elementAt(i);
                if (pasvect == null) {
                    pasvect = new Vector(len);
                }
                pasvect.add(this.getPublisherAssertion(asi));
            }
            report = ireg.getAssertionStatusReport(authinfo, "status:fromKey_incomplete");
            v = report.getAssertionStatusItemVector();
            len = v != null ? v.size() : 0;
            for (i = 0; i < len; ++i) {
                asi = (AssertionStatusItem)v.elementAt(i);
                if (pasvect == null) {
                    pasvect = new Vector(len);
                }
                pasvect.add(this.getPublisherAssertion(asi));
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error:", (Throwable)e);
        }
        if (pasvect != null && pasvect.size() > 0) {
            try {
                ireg.deletePublisherAssertions(authinfo, (Vector)pasvect);
            }
            catch (RegistryException e) {
                log.error((Object)"Ignorable exception:", (Throwable)e);
            }
        }
    }

    protected BulkResponse deleteOperation(Collection keys, String op) throws JAXRException {
        if (keys == null) {
            throw new JAXRException("Keys provided to " + op + " are null");
        }
        BulkResponseImpl bulk = new BulkResponseImpl();
        Vector keyvect = new Vector();
        ArrayList coll = new ArrayList();
        ArrayList<Object> exceptions = new ArrayList<Object>();
        try {
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Key key = (Key)iter.next();
                keyvect.add(key.getId());
            }
            DispositionReport bd = (DispositionReport)this.executeOperation(keyvect, op);
            keyvect = bd.getResultVector();
            log.debug((Object)("After deleting Business. Obtained vector size:" + keyvect.size()));
            for (int i = 0; keyvect != null && i < keyvect.size(); ++i) {
                Result result = (Result)keyvect.elementAt(i);
                int errno = result.getErrno();
                if (errno == 0) {
                    coll.addAll(keys);
                    continue;
                }
                ErrInfo errinfo = result.getErrInfo();
                DeleteException de = new DeleteException(errinfo.getErrCode() + ":" + errinfo.getErrMsg());
                bulk.setStatus(2);
                exceptions.add(de);
            }
        }
        catch (RegistryException regExcept) {
            DeleteException de = new DeleteException(regExcept.getFaultCode() + ":" + regExcept.getFaultString(), (Throwable)regExcept);
            bulk.setStatus(2);
            exceptions.add(de);
        }
        catch (JAXRException tran) {
            exceptions.add((Object)new JAXRException("Apache JAXR Impl:", (Throwable)tran));
            bulk.setStatus(2);
        }
        bulk.setCollection(coll);
        bulk.setExceptions(exceptions);
        return bulk;
    }

    private AuthToken getAuthToken(ConnectionImpl connection, IRegistry ireg) throws JAXRException {
        Set creds = connection.getCredentials();
        Iterator it = creds.iterator();
        String username = "";
        String pwd = "";
        while (it.hasNext()) {
            PasswordAuthentication pass = (PasswordAuthentication)it.next();
            username = pass.getUserName();
            pwd = new String(pass.getPassword());
        }
        AuthToken token = null;
        try {
            token = ireg.getAuthToken(username, pwd);
        }
        catch (Exception e) {
            log.error((Object)"Exception::", (Throwable)e);
            throw new JAXRException((Throwable)e);
        }
        return token;
    }

    private PublisherAssertion getPublisherAssertion(AssertionStatusItem asi) {
        String sourceKey = asi.getFromKey();
        String targetKey = asi.getToKey();
        PublisherAssertion pa = new PublisherAssertion();
        pa.setFromKey(sourceKey);
        pa.setToKey(targetKey);
        KeyedReference keyr = asi.getKeyedReference();
        pa.setKeyedReference(keyr);
        pa.setTModelKey(keyr.getTModelKey());
        pa.setKeyName(keyr.getKeyName());
        pa.setKeyValue(keyr.getKeyValue());
        return pa;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

