/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server.jmx;

import java.util.List;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.jms.server.destination.TopicService;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.mq.server.jmx.TopicMBean;
import org.w3c.dom.Element;

@ManagementObject(componentType=@ManagementComponent(type="JMSDestination", subtype="Topic"), properties=ManagementProperties.EXPLICIT)
public class Topic
implements MBeanRegistration,
TopicMBean {
    private TopicService delegate;

    public Topic() {
        this.delegate = new TopicService();
    }

    public Topic(boolean createProgramatically) {
        this.delegate = new TopicService(createProgramatically);
    }

    @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
    public void create() throws Exception {
        this.delegate.create();
    }

    @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
    public void destroy() {
        this.delegate.destroy();
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The write-cache size, can only be set when queue is stopped")
    public int getDownCacheSize() {
        return this.delegate.getDownCacheSize();
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The in-memory message limit, can only be set when queue is stopped")
    public int getFullSize() {
        return this.delegate.getFullSize();
    }

    @ManagementProperty(use={ViewUse.RUNTIME})
    public String getJNDIName() {
        return this.delegate.getJNDIName();
    }

    @ManagementOperation(description="List all non durable mesages", impact=ManagedOperation.Impact.ReadOnly)
    public List listNonDurableMessages(String subscriptionId) throws Exception {
        return this.delegate.listNonDurableMessages(subscriptionId);
    }

    @ManagementProperty(use={ViewUse.RUNTIME})
    public String getName() {
        return this.delegate.getName();
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="he paging size, can only be set when queue is stopped")
    public int getPageSize() {
        return this.delegate.getPageSize();
    }

    public MBeanServer getServer() {
        return this.delegate.getServer();
    }

    public ObjectName getServerPeer() {
        return this.delegate.getServerPeer();
    }

    @ManagementProperty(use={ViewUse.STATISTIC})
    public boolean isCreatedProgrammatically() {
        return this.delegate.isCreatedProgrammatically();
    }

    @ManagementOperation(description="List all durable mesages", impact=ManagedOperation.Impact.ReadOnly)
    public List listMessagesDurableSub(String arg0, String arg1, String arg2) throws Exception {
        return this.delegate.listDurableMessages(arg0, arg1);
    }

    @ManagementOperation(description="List all non durable mesages", impact=ManagedOperation.Impact.ReadOnly)
    public List listMessagesNonDurableSub(long arg0, String arg1) throws Exception {
        return this.delegate.listNonDurableMessages(arg1);
    }

    @ManagementOperation(description="List subscriptions on text", impact=ManagedOperation.Impact.ReadOnly)
    public String listSubscriptionsAsText() throws Exception {
        return this.delegate.listAllSubscriptionsAsHTML();
    }

    @ManagementOperation(description="List subscriptions on text", impact=ManagedOperation.Impact.ReadOnly)
    public String listSubscriptionsAsText(boolean arg0) throws Exception {
        return this.delegate.listAllSubscriptionsAsHTML();
    }

    @ManagementOperation(description="Remove all the messages on the queue DB", impact=ManagedOperation.Impact.WriteOnly)
    public void removeAllMessages() throws Exception {
        this.delegate.removeAllMessages();
    }

    public void setDownCacheSize(int arg0) {
        this.delegate.setDownCacheSize(arg0);
    }

    public void setFullSize(int arg0) {
        this.delegate.setFullSize(arg0);
    }

    public void setJNDIName(String arg0) throws Exception {
        this.delegate.setJNDIName(arg0);
    }

    public void setPageSize(int arg0) {
        this.delegate.setPageSize(arg0);
    }

    public void setSecurityConfig(Element arg0) throws Exception {
        this.delegate.setSecurityConfig(arg0);
    }

    public void setSecurityConf(Element arg0) throws Exception {
        this.delegate.setSecurityConfig(arg0);
    }

    public void setSecurityManager(ObjectName arg0) {
    }

    public void setServerPeer(ObjectName arg0) {
        this.delegate.setServerPeer(arg0);
    }

    public void setDestinationManager(ObjectName arg0) throws Exception {
        ObjectName peer = new ObjectName("jboss.messaging:service=ServerPeer");
        this.delegate.setServerPeer(peer);
    }

    @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
    public void start() throws Exception {
        this.delegate.start();
    }

    @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
    public void stop() {
        this.delegate.stop();
    }

    public int subscriptionCount() throws Exception {
        return this.delegate.getAllSubscriptionsCount();
    }

    public int subscriptionCount(boolean arg0) throws Exception {
        return arg0 ? this.delegate.getDurableSubscriptionsCount() : this.delegate.getNonDurableSubscriptionsCount();
    }

    public ObjectName getExpiryDestination() {
        return null;
    }

    public void setExpiryDestination(ObjectName destination) {
        System.err.println("There is no ExpiryDestination currently");
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void postDeregister() {
        this.delegate.postDeregister();
    }

    public void postRegister(Boolean registrationDone) {
        this.delegate.postRegister(registrationDone);
    }

    public void preDeregister() throws Exception {
        this.delegate.preDeregister();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return this.delegate.preRegister(server, name);
    }
}

