/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.JCAManagedConnectionFactoryMBean;

public class JCAManagedConnectionFactory
extends J2EEManagedObject
implements JCAManagedConnectionFactoryMBean {
    private static Logger log = Logger.getLogger(JCAManagedConnectionFactory.class);

    public static ObjectName create(MBeanServer mbeanServer, String resName, ObjectName jsr77ParentName) {
        ObjectName jsr77Name = null;
        try {
            JCAManagedConnectionFactory mcf = new JCAManagedConnectionFactory(resName, jsr77ParentName);
            jsr77Name = mcf.getObjectName();
            mbeanServer.registerMBean(mcf, jsr77Name);
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 JCAManagedConnectionFactory: " + resName), (Throwable)e);
        }
        return jsr77Name;
    }

    public static void destroy(MBeanServer mbeanServer, String resName) {
        try {
            String mcfName = J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "JCAManagedConnectionFactory" + ",name=" + resName + ",*";
            J2EEManagedObject.removeObject(mbeanServer, mcfName);
        }
        catch (Exception e) {
            log.debug((Object)("Could not destroy JSR-77 JCAManagedConnectionFactory: " + resName), (Throwable)e);
        }
    }

    public JCAManagedConnectionFactory(String resName, ObjectName jsr77ParentName) throws MalformedObjectNameException, InvalidParentException {
        super("JCAManagedConnectionFactory", resName, jsr77ParentName);
    }

    public String toString() {
        return "JCAManagedConnectionFactory { " + super.toString() + " } [ " + " ]";
    }

    protected Hashtable getParentKeys(ObjectName parentName) {
        Hashtable<String, String> keys = new Hashtable<String, String>();
        Hashtable<String, String> nameProps = parentName.getKeyPropertyList();
        String serverName = nameProps.get("J2EEServer");
        keys.put("J2EEServer", serverName);
        return keys;
    }
}

