/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.retrieval.basic;

import java.lang.annotation.Annotation;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.loader.MetaDataLoader;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.basic.BasicItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAnnotationsItem
extends BasicItem<Annotation[]>
implements AnnotationsItem {
    private AnnotationItem<? extends Annotation>[] annotationItems;
    private Annotation[] annotations;

    public BasicAnnotationsItem(MetaDataLoader loader, AnnotationItem<? extends Annotation>[] annotationItems) {
        super(loader);
        if (annotationItems == null) {
            throw new IllegalArgumentException("Null annotation items");
        }
        this.annotationItems = annotationItems;
        if (annotationItems.length == 0) {
            this.annotations = MetaData.NO_ANNOTATIONS;
        }
    }

    @Override
    public Annotation[] getValue() {
        if (this.annotations == null) {
            Annotation[] temp = new Annotation[this.annotationItems.length];
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = this.annotationItems[i].getAnnotation();
            }
            this.annotations = temp;
        }
        return this.annotations;
    }

    @Override
    public AnnotationItem<? extends Annotation>[] getAnnotations() {
        return this.annotationItems;
    }

    @Override
    public boolean isCachable() {
        if (!super.isCachable()) {
            return false;
        }
        for (AnnotationItem<? extends Annotation> item : this.annotationItems) {
            if (item.isCachable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        for (AnnotationItem<? extends Annotation> item : this.annotationItems) {
            if (item.isValid()) continue;
            return false;
        }
        return true;
    }
}

