/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.TreeBuilder;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;

public class ResourcesTreeBuilder
implements TreeBuilder {
    public void buildTree(TreeControl treeControl, ApplicationServlet servlet, HttpServletRequest request) {
        MessageResources resources = (MessageResources)servlet.getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        this.addSubtree(treeControl.getRoot(), resources, locale);
    }

    protected void addSubtree(TreeControlNode root, MessageResources resources, Locale locale) {
        try {
            String domain = root.getDomain();
            TreeControlNode subtree = new TreeControlNode("Global Resource Administration", "folder_16_pad.gif", resources.getMessage(locale, "resources.treeBuilder.subtreeNode"), null, "content", true, domain);
            TreeControlNode datasources = new TreeControlNode("Globally Administer Data Sources", "Datasource.gif", resources.getMessage(locale, "resources.treeBuilder.datasources"), "resources/listDataSources.do?resourcetype=Global&domain=" + domain + "&forward=" + URLEncoder.encode("DataSources List Setup", "UTF-8"), "content", false, domain);
            TreeControlNode mailsessions = new TreeControlNode("Globally Administer Mail Sessions ", "Mailsession.gif", resources.getMessage(locale, "resources.treeBuilder.mailsessions"), "resources/listMailSessions.do?resourcetype=Global&domain=" + domain + "&forward=" + URLEncoder.encode("MailSessions List Setup", "UTF-8"), "content", false, domain);
            TreeControlNode userdbs = new TreeControlNode("Globally Administer UserDatabase Entries", "Realm.gif", resources.getMessage(locale, "resources.treeBuilder.databases"), "resources/listUserDatabases.do?domain=" + domain + "&forward=" + URLEncoder.encode("UserDatabases List Setup", "UTF-8"), "content", false, domain);
            TreeControlNode envs = new TreeControlNode("Globally Administer Environment Entries", "EnvironmentEntries.gif", resources.getMessage(locale, "resources.env.entries"), "resources/listEnvEntries.do?resourcetype=Global&domain=" + domain + "&forward=" + URLEncoder.encode("EnvEntries List Setup", "UTF-8"), "content", false, domain);
            root.addChild(subtree);
            subtree.addChild(datasources);
            subtree.addChild(mailsessions);
            subtree.addChild(envs);
            subtree.addChild(userdbs);
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
    }
}

