/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.realm;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.TomcatTreeBuilder;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;
import org.apache.webapp.admin.realm.MemoryRealmForm;
import org.apache.webapp.admin.valve.ValveUtil;

public final class SaveMemoryRealmAction
extends Action {
    private String[] createStandardRealmTypes = new String[]{"java.lang.String"};
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        MemoryRealmForm rform = (MemoryRealmForm)form;
        String adminAction = rform.getAdminAction();
        String rObjectName = rform.getObjectName();
        if ("Create".equals(adminAction)) {
            String operation = null;
            Object[] values = null;
            try {
                String parent = rform.getParentObjectName();
                String objectName = ValveUtil.getObjectName(parent, ":type=Realm");
                ObjectName pname = new ObjectName(parent);
                StringBuffer sb = new StringBuffer(pname.getDomain());
                try {
                    if ("Service".equalsIgnoreCase(pname.getKeyProperty("type"))) {
                        sb.append(":type=Engine");
                        parent = sb.toString();
                    }
                }
                catch (Exception e) {
                    String message = resources.getMessage(locale, "error.engineName.bad", (Object)sb.toString());
                    this.getServlet().log(message);
                    response.sendError(400, message);
                    return null;
                }
                ObjectName oname = new ObjectName(objectName);
                if (this.mBServer.isRegistered(oname)) {
                    ActionMessages errors = new ActionMessages();
                    errors.add("realmName", new ActionMessage("error.realmName.exists"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                String domain = oname.getDomain();
                ObjectName fname = TomcatTreeBuilder.getMBeanFactory();
                values = new String[]{parent};
                operation = "createMemoryRealm";
                rObjectName = (String)this.mBServer.invoke(fname, operation, values, this.createStandardRealmTypes);
                TreeControl control = (TreeControl)session.getAttribute("treeControlTest");
                if (control != null) {
                    TreeControlNode parentNode = control.findNode(rform.getParentObjectName());
                    if (parentNode != null) {
                        String nodeLabel = rform.getNodeLabel();
                        String encodedName = URLEncoder.encode(rObjectName, "UTF-8");
                        TreeControlNode childNode = new TreeControlNode(rObjectName, "Realm.gif", nodeLabel, "EditRealm.do?select=" + encodedName, "content", true, domain);
                        parentNode.addChild(childNode);
                    } else {
                        this.getServlet().log("Cannot find parent node '" + parent + "'");
                    }
                } else {
                    this.getServlet().log("Cannot find TreeControlNode!");
                }
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.invoke", operation), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.invoke", operation));
                return null;
            }
        }
        String attribute = null;
        try {
            ObjectName roname = new ObjectName(rObjectName);
            attribute = "pathname";
            this.mBServer.setAttribute(roname, new Attribute("pathname", rform.getPathName()));
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.set", (Object)attribute), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.set", (Object)attribute));
            return null;
        }
        session.removeAttribute(mapping.getAttribute());
        return mapping.findForward("Save Successful");
    }
}

