package bonjour;

// BonjourServer.java
// Copyright and License : http://java.sun.com/j2se/1.4.2/docs/guide/idl/examplelicense.html

import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;
import org.omg.CORBA.*;
import org.omg.PortableServer.*;
import org.omg.PortableServer.POA;

import java.util.Properties;

class BonjourImpl extends BonjourPOA {
  private ORB orb;

  public void setORB(ORB orb_val) {
    orb = orb_val; 
  }
    
  // implement sayBonjour() method
  public String sayCoucou(String s) {
    return "\nBonjour " + s + "\n";
  }
    
  // implement shutdown() method
  public void shutdown() {
    orb.shutdown(false);
  }
}


public class BonjourServer {

  public static void main(String args[]) {
    try{
      // create and initialize the ORB

      ORB orb = ORB.init(args, null);

      // get reference to rootpoa & activate the POAManager
      POA rootpoa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
	  
      rootpoa.the_POAManager().activate();

      // create servant and register it with the ORB
      BonjourImpl BonjourImpl = new BonjourImpl();
      BonjourImpl.setORB(orb); 

      // get object reference from the servant
      org.omg.CORBA.Object ref = rootpoa.servant_to_reference(BonjourImpl);
      Bonjour href = BonjourHelper.narrow(ref);
	  
	  System.out.println("Server initialized...");
	  
      // get the root naming context
      org.omg.CORBA.Object objRef =
          orb.resolve_initial_references("NameService");

     // Use NamingContextExt which is part of the Interoperable
      // Naming Service (INS) specification.
      NamingContextExt ncRef = NamingContextExtHelper.narrow(objRef);

	  System.out.println("NamingContext found...");

      // bind the Object Reference in Naming
      String name = "Bonjour";
      NameComponent path[] = ncRef.to_name( name );
      ncRef.rebind(path, href);

      System.out.println("Server ready and waiting...");

      // wait for invocations from clients
      orb.run();

	} 
	
      catch (Exception e) {
        System.err.println("ERROR: " + e);
        e.printStackTrace(System.out);
      }
	  
      System.out.println("Server Exiting ...");
	
  }
}
 