package repertoire.metier;

/*
 * @(#)DomEcho01.java	1.9 98/11/10
 *
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

import javax.xml.parsers.DocumentBuilder; 
import javax.xml.parsers.DocumentBuilderFactory;  
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;  
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;

import repertoire.DOMUtil;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Implmentation de PersonneDAO sur un support de persistence en XML
 * @author Lionel Mdini
 */
public class PersonneXMLDAO implements PersonneDAO {

    // Global value so it can be ref'd by the tree-adapter
    static Document document;
    static String filename;

    public PersonneXMLDAO(String fichier) {
    	filename = new String(fichier);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        //factory.setValidating(true);   
        //factory.setNamespaceAware(true);
        try {
           DocumentBuilder builder = factory.newDocumentBuilder();
           document = builder.parse( new File(fichier) );
           
        } catch (SAXException sxe) {
           // Error generated during parsing)
           Exception  x = sxe;
           if (sxe.getException() != null)
               x = sxe.getException();
           x.printStackTrace();

        } catch (ParserConfigurationException pce) {
            // Parser with specified options can't be built
            pce.printStackTrace();

        } catch (IOException ioe) {
           // I/O error
           ioe.printStackTrace();
        }
    }

    public void addPersonne(Personne item) {
    	Element docElt = document.getDocumentElement();

    	Element personneElt = document.createElement("Personne");
    	docElt.appendChild(personneElt);

    	Element nomElt = document.createElement("Nom");
    	nomElt.setTextContent(item.getNom());
    	personneElt.appendChild(nomElt);

    	Element prenomElt = document.createElement("Prenom");
    	prenomElt.setTextContent(item.getPrenom());
    	personneElt.appendChild(prenomElt);

    	Element numeroElt = document.createElement("Numero");
    	numeroElt.setTextContent(item.getNumero());
    	personneElt.appendChild(numeroElt);

    	DOMUtil.writeXmlToFile(filename, document);
    }

    public void deletePersonne(Personne item) {

    	String nom = null;
    	String prenom = null;
    	String numero = null;

    	//Rcupration de chaque personne de la liste
    	NodeList nl = document.getElementsByTagName("Personne");
    	for (int i = 0; i< nl.getLength(); i++) {
        	Element personneElt = (Element) nl.item(i);

        	//Rcupration des champs
	    	NodeList nl2 = personneElt.getChildNodes();
	    	for (int j = 0; j < nl2.getLength(); j++) {
	    		if (nl2.item(j).getNodeType() == Node.ELEMENT_NODE) {
	    			Node node = nl2.item(j);
	    			if (((Element) node).getTagName().equals("Nom"))
	    				nom = node.getTextContent();
	    			if (((Element) node).getTagName().equals("Prenom"))
	    				prenom = node.getTextContent();
	    			if (((Element) node).getTagName().equals("Numero"))
	    				numero = node.getTextContent();
	    		}
	    	}

	    	//Suppression si la personne correspond
        	if (nom.equals(item.getNom()) && prenom.equals(item.getPrenom()) && numero.equals(item.getNumero())) {
        		personneElt.getParentNode().removeChild(personneElt);
                i--;
        	}
    	}
    	DOMUtil.writeXmlToFile(filename, document);
    }

    public List<Personne> getAllPersonnes() {
    	List<Personne> liste = new ArrayList<Personne>();

    	String nom = null;
    	String prenom = null;
    	String numero = null;

    	NodeList nl = document.getDocumentElement().getChildNodes();
    	for (int i = 0; i < nl.getLength(); i++) {
    		if (nl.item(i).getNodeType() == Node.ELEMENT_NODE && ((Element) nl.item(i)).getTagName().equals("Personne")) {
    	    	NodeList nl2 = nl.item(i).getChildNodes();
    	    	for (int j = 0; j < nl2.getLength(); j++) {
    	    		if (nl2.item(j).getNodeType() == Node.ELEMENT_NODE) {
    	    			Node node = nl2.item(j);
    	    			if (((Element) node).getTagName().equals("Nom"))
    	    				nom = node.getTextContent();
    	    			if (((Element) node).getTagName().equals("Prenom"))
    	    				prenom = node.getTextContent();
    	    			if (((Element) node).getTagName().equals("Numero"))
    	    				numero = node.getTextContent();
    	    		}
    	    	}
    			liste.add(new Personne (nom, prenom, numero, null));
    		}
    	}
    	return liste;
    }

	public String getInfos() {
		return "DAO XML : " + this.toString() + " - nom du fichier XML = " + filename;
	}
}