package repertoire.metier;

import java.util.List;

/**
 * Interface des DAO rattachs  la classe Personne.
 * @author Lionel Mdini
 */
public interface PersonneDAO {

	/**
	 * Ajoute une personne au support de persistence
	 * @param item la personne  rajouter
	 */
    public void addPersonne(Personne item);

    /**
	 * Supprime toutes les occurrences d'une personne dans le support de persistence
	 * @param item la personne  supprimer
	 */
    public void deletePersonne(Personne item);
 
    /**
     * Renvoie une liste de Personnes telles qu'elles sont renseignes dans le support de persistence
     */
    public List<Personne> getAllPersonnes();
 
    /**
     * Renvoie des infos sur le DAO
     * @return du texte indiquant notamment le type de DAO
     */
    public String getInfos();
}