package repertoire.metier;

import java.util.List;

/**
 * Reprsente une personne du rpertoire avec les champs nom, prnom et numro de tlphone.
 * Principal objet mtier de l'application.
 * @author Lionel Mdini
 */
public class Personne {

	String nom = null;
	String prenom = null;
	String numero = null;
    PersonneDAO dao;

	public Personne (PersonneDAO dao) {
        this.dao = dao;
	}

	public Personne (String nom, String prenom, String numero, PersonneDAO dao) {
		this.nom = new String (nom);
		this.prenom = new String (prenom);
		this.numero = new String (numero);
        this.dao = dao;
	}

    public boolean equals(Personne other) {
        return (this.nom.equals(other.getNom())) && (this.nom.equals(other.getNom())) && (this.numero.equals(other.getNumero()));
    }

	public String getNom() {
		return this.nom;
	}

	public void setNom(String n) {
		this.nom = n;
	}

	public String getPrenom() {
		return this.prenom;
	}

	public void setPrenom(String p) {
		this.nom = p;
	}

	public String getNumero() {
		return this.numero;
	}

	public void setNumero(String n) {
		this.numero = n;
	}

    public void save() {
        dao.addPersonne(this);
    }

    public void delete() {
        dao.deletePersonne(this);
    }

    public List<Personne> getAllPersonnes() {
    	return dao.getAllPersonnes();
    }
}