package repertoire;

import java.io.BufferedReader;
import java.io.InputStreamReader;

/**
 * Interface utilisateur du rpertoire.
 * Fonctionne comme client de celui-ci.
 * Cette classe contient le main de l'application ; elle instancie le rpertoire avant de l'appeler.
 * @author Lionel Mdini
 */
public class RepertoireUI {

	//Variable globale (singleton)
	static Repertoire repertoire;

	/**
	 * Boucle sans fin d'affichage du menu, rcupration des entres de l'utilisateur, appel des mthodes correspondantes du rpertoire et affichage des rponses.
	 */
	public static void main (String argv[]) {
		repertoire = new Repertoire("test-repertoire.xml");

		String nom = null;
		String prenom = null;
		String numero = null;

		for (;;) {
			menu();
			int c = new String (readLine()).charAt(0) - '0';
			switch (c){
			case 1:
				try {
					System.out.print("Nom : ");
					nom = readLine();
					System.out.print("Prnom : ");
					prenom = readLine();
					System.out.print("Numro : ");
					numero = readLine();
				} catch (Exception e) {
					e.printStackTrace();
				}

				repertoire.addPersonne(nom, prenom, numero);
				break;

			case 2:
				try {
					System.out.print("Nom : ");
					nom = readLine();
					System.out.print("Prnom : ");
					prenom = readLine();
					System.out.print("Numro : ");
					numero = readLine();
				} catch (Exception e) {
					e.printStackTrace();
				}

				repertoire.removePersonne(nom, prenom, numero);
				break;

			case 3:
				System.out.println("Personnes dans le rpertoire :\n");
				System.out.println(repertoire.listPersonnes());
				break;

			case 4:
				repertoire.initPersonnes();
				System.out.println("Liste des personnes rinitialisee par rapport au DAO.\n\n");
				break;

			case 5:
				return;
			}
		}
	}

	public static void menu() {
		System.out.println("Menu\n\n");
		System.out.println("1)\tAjouter une personne\n");
		System.out.println("2)\tSupprimer une personne\n");
		System.out.println("3)\tLister les personnes\n");
        System.out.println("4)\tRinitialiser le rpertoire\n");
        System.out.println("5)\tQuitter\n");
	}

//	 ---------------------------------------------
//   Code trouve a : http://www.wellho.net/resources/ex.php4?item=j703/WellHouseInput.java
	public static String readLine() {
		BufferedReader standard = new BufferedReader(new InputStreamReader(System.in));
	    try{
	    	String inline = standard.readLine();
	    	return inline;
	    } catch (Exception e) {
	    	return ("data entry error");
	    }
	}
}