package repertoire;

import java.util.Iterator;
import java.util.List;

import repertoire.metier.Personne;
import repertoire.metier.PersonneDAO;
import repertoire.metier.PersonneXMLDAO;

/**
 * Rpertoire contenant des personnes. C'est le noyau de l'application.
 * Cette classe rpond  des requtes (appels de mthodes) d'un client (RepertoireUI).
 * Pour cela, elle gre en interne une liste qu'elle synchronise avec le support de persistence.
 * @author Lionel Mdini
 */
public class Repertoire {

    List<Personne> personnes;
    PersonneDAO dao;

    public Repertoire(String d) {
        dao = new PersonneXMLDAO(d);
        initPersonnes();
    }

    public void addPersonne(String nom, String prenom, String numero) {
        Personne personne = new Personne(nom, prenom, numero, dao);

        // Ajout dans la liste
        try {
            personne.save();
        } catch (Exception e) {
            e.printStackTrace();
        }

        // Ajout dans le support de persistance
        personnes.add(personne);
    }

    public void removePersonne(String nom, String prenom, String numero) {
        Personne personne = new Personne(nom, prenom, numero, dao);

        // Suppression dans la liste
        for (Iterator<Personne> i = personnes.iterator(); i.hasNext();) {
            Personne temp = (Personne) i.next();
            if (temp.equals(personne)) {
                personnes.remove(temp);
                removePersonne(nom, prenom, numero);
                return;
            }
        }

        // Suppression dans le support de persistance
        try {
            personne.delete();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String listPersonnes() {
        String res = new String();
        for (Iterator<Personne> i = personnes.iterator(); i.hasNext();) {
            Personne personne = (Personne) i.next();
            res += "Prnom :\t" + personne.getPrenom() + "\n";
            res += "Nom    :\t" + personne.getNom() + "\n";
            res += "Numro :\t" + personne.getNumero() + "\n\n";
        }
        return res;
    }

    /**
     *  Synchronisation de la liste et du support de persistance
     */
    public void initPersonnes() {
        Personne temp = new Personne(dao);
        personnes = temp.getAllPersonnes();
    }
}