
#include "App.h"

#include "Transform.h"

#include "MeshIO.h"
#include "BufferManager.h"
#include "ShaderManager.h"


class TP : public gk::App
{
    gk::GLShaderProgram *program;
    
public:
    // creation de la fenetre avec les reglages par defaut.
    TP( )
        :
        gk::App(1024, 768)
    {}
    
    // creation de la fenetre avec des reglages particuliers.
    TP( const int w, const int h, const gk::AppSettings& settings )
        :
        gk::App(w, h, settings)
    {}
    
    // creation de la fenetre avec des reglages particuliers, autre solution.
    TP( const int w, const int h )
        :
        gk::App()       // creation de l'application, mais pas du contexte opengl et de la fenetre
    {
        // parametrage du contexte opengl et de la fenetre.
        gk::AppSettings settings;
        settings.setSamples(4);
        
        createWindow(w, h, settings);   
    }
    
    ~TP( ) {}
    
    int init( )
    {
        // gk::MeshIO::read( mesh_filename ) pour lire un objet 3d
        // gk::createAttributeBuffer( ) pour creer un vertex buffer
        // gk::createIndexBuffer( ) pour creer un index buffer
        
        // pour creer un shader program en compilant les fichiers sources vertex et fragment
        program= gk::createShaderProgram( "vertex.vsl", "fragment.fsl" );  
        if(program == NULL || program->createGLResource() < 0)
            // erreur de chargement des fichiers sources ou de compilation des shaders, sortir de l'application
            return -1;
        
        return 0;       // tout c'est bien passe, sinon renvoyer -1
    }
    
    int quit( ) 
    {
        return 0;
    }
    
    int draw( )
    {
        if(key(SDLK_ESCAPE))
            // fermer l'application si l'utilisateur appuie sur ESCAPE
            Close();
        
        // activer le shader
        glUseProgram(program->name());
        
        // parametrer le shader, par exemple, mvpMatrix
        
        // activer les buffers d'attributs
        // activer le buffer d'indice
        // draw
        
        // afficher le buffer de dessin
        SDL_GL_SwapBuffers();
        return 1;       // continuer
    }
};


int main( int argc, char **argv )
{
    TP app;
    app.run();
    
    return 0;
}

