solution "TP"
	configurations { "debug", "release", "gprof" }
    
		local gkit_files = 
		{
			"gKit/*.cpp", "gKit/*.h",
			"gKit/GL/*.cpp", "gKit/GL/*.h",
--~ 			"gKit/CL/*.cpp", "gKit/CL/*.h",	-- commenter si openCL n'est pas installe
			
			"gKit/Widgets/nvwidgets/nvWidgets.cpp", "gKit/Widgets/nvwidgets/nvGLWidgets.cpp", 
			"gKit/Widgets/nvwidgets/nvSdlWidgets.cpp", "gKit/Widgets/nvwidgets/nvSdlTextPainter.cpp",
			"gKit/Widgets/nvglutils/*.h",
		}
		
		includedirs
		{
			".",
			"gKit",
			"gKit/Widgets",
--~ 			"/usr/local/cuda/include/"	-- include openCL nvidia	-- commenter si openCL n'est pas installe
--~ 			"/usr/local/appSDK/include/"	-- include openCL amd app
		}
		
		defines { "GK_OPENGL4", "VERBOSE" }
		defines { "NVWIDGETS_EXPORTS" } -- for nvWidgets
		
		configuration "debug"
			defines { "DEBUG" } 
			flags { "Symbols" }
		
		configuration "release"
--~ 			defines { "NDEBUG" }
			flags { "OptimizeSpeed" }
		
		configuration "linux"
			buildoptions { "-pipe", "`sdl-config --cflags`", "-march=native" }
			
			includedirs { "local/linux/include" }
			linkoptions { "-Llocal/linux/lib -lGLEW" }	-- version 64 bits
			linkoptions { "-Wl,-rpath,local/linux/lib" }

--~ 			linkoptions { "-Llocal/linux/lib32 -lGLEW" }	-- version 32bits
--~ 			linkoptions { "-Wl,-rpath,local/linux/lib32" }

			linkoptions { "`sdl-config --libs`" }
			links { "GLEW", "GL", "GLU", "SDL_image", "SDL_ttf" }
--~ 				, "OpenCL" }
		
		configuration { "linux", "release" }
			buildoptions { "-mfpmath=sse -msse3" }

		configuration "gprof"
			flags { "Symbols" }
			buildoptions { "-pg", "-fprofile-arcs" }
			linkoptions { "-pg", "-fprofile-arcs" }

		configuration "windows"
			includedirs { "local/windows/include" }
			libdirs { "local/windows/lib" }
			defines { "WIN32", "NVWIDGETS_EXPORTS", "_USE_MATH_DEFINES", "_CRT_SECURE_NO_WARNINGS" }
			defines { "NOMINMAX" } -- allow std::min() and std::max() in vc++ :(((  
			links { "opengl32", "glu32", "glew32", "SDL", "SDLmain", "SDL_image", "SDL_ttf" }
		
		configuration "macosx"
			includedirs { "local/macosx/include" }
			libdirs { "local/macosx/lib" }
			defines { "APPLE_OSX", "__APPLE_CC__" }
			files
			{
				"SDLMain.m"
			}
			
			libdirs { "OpenGL.framework", "SDL.framework", "SDL_image.framework", "SDL_ttf.framework", "Cocoa.framework" }
			links { "GLEW" }
			

local project_files = {
	"shadercc",		-- compiler des shaders
	"image_viewer",		-- afficher des images hdr, png, jpg, bmp, etc.
	"mesh_viewer",		-- afficher un objet 3d
	"batch_main",		-- mesurer le nombre de batchs realisables
	"tessellation_tuto",	-- exemple d'utilisation de la tessellation et d'opengl4, sur un seul triangle
	"tessellation_main",	-- exemple d'utilisation de la tessellation et d'opengl4, sur un objet
--~ 	"deferred_main",	-- derrefed lighting
--~ 	"opencl_main",		-- exemple opencl/opengl
--~ 	"deferred_opencl",	-- deferred lighting, accumulation des influences des sources en opencl
--~ 	"quad_shading"
}

for i, name in ipairs(project_files) do
	project(name)
		language "C++"
		kind "ConsoleApp"
		files ( gkit_files )
		files { name..'.cpp' }
end

project("tuto")
	language "C++"
	kind "ConsoleApp"
	files ( gkit_files )
	files { "tuto.cpp" }	-- ajoutez les autres fichiers de votre projet et regenerez le projet, ./premake4 gmake; make tuto
