
#ifndef _CL_QUEUE_H
#define _CL_QUEUE_H

#include <cstdio>
#include <CL/CLPlatform.h>

#include "CLResource.h"


namespace gk {

class CLKernel;
    
class CLQueue : public CLResource
{
    cl_command_queue m_queue;
    
public:
    CLQueue( const cl_command_queue_properties flags= 0 );
    ~CLQueue( );

    int createCLResource( );
    int releaseCLResource( );

    const cl_command_queue *object( ) const
    {
        return &m_queue;
    }

    cl_command_queue *object( )
    {
        return &m_queue;
    }

    cl_command_queue queue( ) const
    {
        return m_queue;
    }
    
    int dispatch( CLKernel *kernel, const size_t global_size, const size_t group_size, cl_event *wait= NULL );
    int dispatch2D( CLKernel *kernel, const size_t global_width, const size_t global_height, const size_t group_width, const size_t group_height, cl_event *wait= NULL );
    int dispatch3D( CLKernel *kernel, cl_event *wait= NULL );
};

}       // namespace gk

#endif
