
#ifndef _CL_IMAGE_H
#define _CL_IMAGE_H

#include <CL/CLPlatform.h>

#include "CLResource.h"


namespace gk {

struct ImageOrigin
{
    size_t x;
    size_t y;
    size_t z;
    
    ImageOrigin( const size_t _x, const size_t _y, const size_t _z= 0 )
        :
        x(_x),
        y(_y),
        z(_z)
    {}
    
    operator const size_t *( ) const
    {
        return &x;
    }
};

struct ImageRegion
{
    size_t width;
    size_t height;
    size_t depth;
    
    ImageRegion( const size_t w, const size_t h, const size_t d= 1 )
        :
        width(w),
        height(h),
        depth(d)
    {}
    
    operator const size_t *( ) const
    {
        return &width;
    }
};


class CLImage : public CLResource
{
protected:
    cl_mem m_image;
    size_t m_width;
    size_t m_height;
    size_t m_row_pitch;
    
public:
    CLImage( const cl_mem_flags flags, const unsigned int glname, const unsigned int texture_target, const int level );
    CLImage( const cl_mem_flags flags, const cl_image_format *format, const size_t width, const size_t height, void *data= NULL, const size_t pitch= 0 );
    ~CLImage( ) {}
    
    int createCLResource( );
    int releaseCLResource( );
    
    int update( const ImageOrigin& origin, const ImageRegion& region, const void *data, const cl_bool block= CL_FALSE, cl_event *wait= NULL );
    int update( const void *data, cl_bool block= CL_FALSE, cl_event *wait= NULL );
    int update( const size_t x, const size_t y, const size_t w, const size_t h, const void *data, const cl_bool block= CL_FALSE, cl_event *wait= NULL );
    
    int get( const ImageOrigin& origin, const ImageRegion& region, void *data, const cl_bool block= CL_FALSE, cl_event *wait= NULL );
    int get( void *data, const cl_bool block= CL_FALSE, cl_event *wait= NULL );
    int get( const size_t x, const size_t y, const size_t w, const size_t h, void *data, const cl_bool block= CL_FALSE, cl_event *wait= NULL );

    const cl_mem *object( ) const
    {
        return &m_image;
    }
    
    cl_mem *object( )
    {
        return &m_image;
    }
    
    cl_mem image( ) const
    {
        return m_image;
    }
};


CLImage *createImage( const cl_mem_flags flags, const cl_image_format *format, const size_t width, const size_t height, void *data= NULL, const size_t pitch= 0 );
CLImage *createReadImage( const cl_image_format *format, const size_t width, const size_t height, void *data= NULL, const size_t pitch= 0 );
CLImage *createWriteImage( const cl_image_format *format, const size_t width, const size_t height, const size_t pitch= 0 );

CLImage *createGLObjectImage( const cl_mem_flags flags, const unsigned int glname, const unsigned int texture_target, const int level= 0 );

//~ CLImage *createReadGLObjectImage( const unsigned int glname, const unsigned int texture_target, const int level= 0 );
//~ CLImage *createWriteGLObjectImage( const unsigned int glname, const unsigned int texture_target, const int level= 0 );

//~ + integration avec gKitGL : createReadImage( GLTexture * texture );

}

#endif
