
#ifndef _CL_BUFFER_H
#define _CL_BUFFER_H

#include <CL/CLPlatform.h>
#include "CLResource.h"


namespace gk {

class CLBuffer : public CLResource
{
    cl_mem m_buffer;
    size_t m_size;
    
public:
    CLBuffer( const cl_mem_flags flags, const unsigned int glname );
    CLBuffer( const cl_mem_flags flags, const size_t size, void *data= NULL );
    ~CLBuffer( ) {}
    
    int createCLResource( );
    int releaseCLResource( );
    
    int update( size_t offset, size_t length, const void *data, cl_bool block= CL_FALSE, cl_event *wait= NULL );
    int get( size_t offset, size_t length, void *data, cl_bool block= CL_FALSE, cl_event *wait= NULL );

    const cl_mem *object( ) const
    {
        return &m_buffer;
    }
    
    cl_mem *object( )
    {
        return &m_buffer;
    }
    
    cl_mem buffer( ) const
    {
        return m_buffer;
    }
};

CLBuffer *createBuffer( const cl_mem_flags flags, const size_t size, void *data= NULL );
CLBuffer *createReadBuffer( const size_t size, void *data= NULL );
CLBuffer *createWriteBuffer( const size_t size );

CLBuffer *createGLObjectBuffer( const cl_mem_flags flags, const unsigned int glname );

}


#endif
