

#include "App.h"
#include "nvwidgets/nvSdlWidgets.h"

#include "Transform.h"

#include "EffectIO.h"
#include "EffectShaderManager.h"
#include "BufferManager.h"

#ifndef GK_OPENGL4
#error opengl4 non supporte par gKit, definir GK_OPENGL4 dans premake4.lua, re-generer le projet et recompiler.
#endif


class Tesselation4 : public gk::App
{
    gk::EffectShaderManager *manager;
    gk::GLShaderProgram *program_triangle;
    gk::GLShaderProgram *program_quad;

    gk::GLBuffer *quad;
    
    nv::SdlUIContext ui;
    int draw_geometry;
    float inner_factor_u;
    float inner_factor_v;
    float edge0_factor;
    float edge1_factor;
    float edge2_factor;
    float edge3_factor;
    
public:
    // creation de la fenetre avec les reglages par defaut.
    Tesselation4( )
        :
        gk::App()
    {
        gk::AppSettings settings;
        settings.setSamples(4);
        createWindow(1024, 768, settings);
    }
    
    ~Tesselation4( ) {}
    
    // a redefinir pour utiliser les widgets.
    void processWindowResize( SDL_ResizeEvent& event )
    {
        ui.reshape(event.w, event.h);
    }
    
    // a redefinir pour utiliser les widgets.
    void processMouseButtonEvent( SDL_MouseButtonEvent& event )
    {
        ui.processMouseButtonEvent(event);
    }
    
    // a redefinir pour utiliser les widgets.
    void processMouseMotionEvent( SDL_MouseMotionEvent& event )
    {
        ui.processMouseMotionEvent(event);
    }
    
    // a redefinir pour utiliser les widgets.
    void processKeyboardEvent( SDL_KeyboardEvent& event )
    {
        ui.processKeyboardEvent(event);
    }
    
    int init( )
    {
        ui.init(windowWidth(), windowHeight());
        
        // creer l'utilitaire de creation de shader a partir d'un fichier .gkfx
        manager= new gk::EffectShaderManager("tessellation.gkfx");
        if(manager == NULL)
            return -1;
        
        // creer le shader program pour la subdivision d'un triangle
        program_triangle= manager->createShaderProgram4("tessellation_triangle");
        if(program_triangle == NULL || program_triangle->createGLResource() < 0)
            // erreur de chargement des fichiers sources ou de compilation des shaders, sortir de l'application
            return -1;
        
        // creer le shader program pour la subdivision d'un quad
        program_quad= manager->createShaderProgram4("tessellation_quad");
        if(program_quad == NULL || program_quad->createGLResource() < 0)
            // erreur de chargement des fichiers sources ou de compilation des shaders, sortir de l'application
            return -1;
        
        // creer un quad, 4 sommets abcd, et un triangle avec les memes sommets abc.
        std::vector<gk::Point> points;
        points.push_back( gk::Point(-.5f, -.5f, .5f) );
        points.push_back( gk::Point( .5f, -.5f, .5f) );
        points.push_back( gk::Point( .5f,  .5f, .5f) );
        points.push_back( gk::Point(-.5f,  .5f, .5f) );
        quad= gk::createAttributeBuffer(points.size(), points.size() * sizeof(gk::Point), &points.front() );
        if(quad == NULL || quad->createGLResource() < 0)
            return -1;
        
        inner_factor_u= 2.f;
        inner_factor_v= 2.f;
        edge0_factor= 2.f;
        edge1_factor= 2.f;
        edge2_factor= 2.f;
        edge3_factor= 2.f;
        
        draw_geometry= 0;
        
        return 0;       // tout c'est bien passe, sinon renvoyer -1
    }
    
    int quit( ) 
    {
        return 0;
    }
    
    int draw( )
    {
        if(key(SDLK_ESCAPE))
            // fermer l'application si l'utilisateur appuie sur ESCAPE
            Close();
        
        glViewport(0, 0, windowWidth(), windowHeight());
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        
        // dessiner les aretes sans remplir les triangles
        glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
        
        // activer le shader
        gk::GLShaderProgram *program= NULL;
        if(draw_geometry == 0)  // dessiner et subdiviser un triangle
            program= program_triangle;
        else if(draw_geometry == 1)
            program= program_quad;
        else
            return 0;   // sortir, erreur de configuration
        
        glUseProgram(program->name());
        
        // parametrer le shader, par exemple, mvpMatrix
        GLint location= program->attribute("position").location();
        glBindBuffer(GL_ARRAY_BUFFER, quad->name());
        glVertexAttribPointer(location, 3, GL_FLOAT, GL_FALSE, 0, 0);
        glEnableVertexAttribArray(location);
        
        gk::setUniform(program->uniform("inner_factor"), inner_factor_u, inner_factor_v);
        gk::setUniform(program->uniform("edge_factor"), edge0_factor, edge1_factor, edge2_factor, edge3_factor);
        
        gk::Transform mvp;  // identite
        gk::setUniform(program->uniform("mvpMatrix"), mvp.matrix());
        
        glLineWidth(2.f);
        if(draw_geometry == 0)
        {
            // dessiner un triangle
            glPatchParameteri(GL_PATCH_VERTICES, 3);
            glDrawArrays(GL_PATCHES, 0, 3);
        }
        else if(draw_geometry == 1)
        {
            // dessiner un quad
            glPatchParameteri(GL_PATCH_VERTICES, 4);
            glDrawArrays(GL_PATCHES, 0, 4);
        }
        
        // nettoyage
        glDisableVertexAttribArray(location);
        glUseProgram(0);
        glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
        
        // interface
        char tmp[1024]= { 0 };
        ui.begin();
            ui.beginGroup(nv::GroupFlags_GrowDownFromLeft);

            ui.doRadioButton(0, nv::Rect(), "draw triangle", &draw_geometry);
            ui.doRadioButton(1, nv::Rect(), "draw quad", &draw_geometry);
        
            sprintf(tmp, "inner level u %.1f", inner_factor_u);
            ui.doLabel(nv::Rect(), tmp);
            ui.doHorizontalSlider(nv::Rect(0, 0, 400, 0), 1.f, 32.f, &inner_factor_u);
            sprintf(tmp, "inner level v %.1f", inner_factor_u);
            ui.doLabel(nv::Rect(), tmp);
            ui.doHorizontalSlider(nv::Rect(0, 0, 400, 0), 1.f, 32.f, &inner_factor_v);
            
            sprintf(tmp, "edge0 level %.1f", edge0_factor);
            ui.doLabel(nv::Rect(), tmp);
            ui.doHorizontalSlider(nv::Rect(0, 0, 400, 0), 1.f, 32.f, &edge0_factor);
            
            sprintf(tmp, "edge1 level %.1f", edge1_factor);
            ui.doLabel(nv::Rect(), tmp);
            ui.doHorizontalSlider(nv::Rect(0, 0, 400, 0), 1.f, 32.f, &edge1_factor);
            
            sprintf(tmp, "edge2 level %.1f", edge2_factor);
            ui.doLabel(nv::Rect(), tmp);
            ui.doHorizontalSlider(nv::Rect(0, 0, 400, 0), 1.f, 32.f, &edge2_factor);

            sprintf(tmp, "edge3 level %.1f", edge3_factor);
            ui.doLabel(nv::Rect(), tmp);
            ui.doHorizontalSlider(nv::Rect(0, 0, 400, 0), 1.f, 32.f, &edge3_factor);

            ui.endGroup();
        ui.end();
        
        if(key(SDLK_LEFT))
        {
            key(SDLK_LEFT)= 0;
            // bouge toutes les valeurs
            inner_factor_u= std::max(1.f, (inner_factor_u -.7f));
            inner_factor_v= std::max(1.f, (inner_factor_v -.7f));
            edge0_factor= std::max(1.f, (edge0_factor -.7f));
            edge1_factor= std::max(1.f, (edge1_factor -.7f));
            edge2_factor= std::max(1.f, (edge2_factor -.7f));
            edge3_factor= std::max(1.f, (edge3_factor -.7f));
        }
        if(key(SDLK_RIGHT))
        {
            key(SDLK_RIGHT)= 0; 
            // bouge toutes les valeurs
            inner_factor_u= std::min(32.f, (inner_factor_u +.7f));
            inner_factor_v= std::min(32.f, (inner_factor_v +.7f));
            edge0_factor= std::min(32.f, (edge0_factor +.7f));
            edge1_factor= std::min(32.f, (edge1_factor +.7f));
            edge2_factor= std::min(32.f, (edge2_factor +.7f));
            edge3_factor= std::min(32.f, (edge3_factor +.7f));
        }
            
        // afficher le buffer de dessin
        SDL_GL_SwapBuffers();
        return 1;       // continuer
    }
};


int main( int argc, char **argv )
{
    Tesselation4 app;
    app.run();
    
    return 0;
}

