
#include "GL/GLPlatform.h"
#include "CL/CLInit.h"
#include "CL/CLKernel.h"
#include "CL/CLBuffer.h"

#include "App.h"

class CLTuto : public gk::App
{
    gk::CLKernel *kernel;
    gk::CLBuffer *a;
    gk::CLBuffer *b;
    
public:
    CLTuto( )
        :
        gk::App( )
    {
        gk::AppSettings settings;
        createWindow(1024, 768, settings);
    }
    
    int init( )
    {
        // initialise opencl et determine quel device utiliser gk::CPU_BIT, gk::GPU_BIT
        // demande a utiliser le meme device que celui utilise par le contexte openGL cree par l'application.
        if(gk::CLInit(gk::GL_BIT) < 0)
            return -1;
        
        // compile un programme et cree le noyau "add"
        kernel= gk::createKernel("kernel.cl", "add");
        if(kernel == NULL || kernel->createCLResource() < 0)
            return -1;
        
        // prepare les donnees
        float data[1000]= {0};
        for(int i= 0; i < 1000; i++)
            data[i]= (float) i;
        
        // alloue le buffer et transfere les donnees (buffer lu par le kernel, ReadBuffer)
        a= gk::createReadBuffer(sizeof(float [1000]), data);    
        if(a == NULL || a->createCLResource() < 0)
            return -1;
        
        // alloue le buffer resultat (buffer ecrit par le kernel, WriteBuffer)
        b= gk::createWriteBuffer(sizeof(float [1000]));
        if(b == NULL || b->createCLResource()  < 0)
            return -1;
        
        return 0;
    }
    
    int quit( )
    {
        // CLManager<> detruit les objets openCL.
        
        gk::CLQuit();   // mais il faut quand meme detruire le contexte openCL.
        return 0;
    }
    
    int draw( )
    {
        if(key(SDLK_ESCAPE))
            Close();
        
        // parametre le noyau openCL
        kernel->setParameter(0, a); // parametre 0
        kernel->setParameter(1, b); // parametre 1
        
        int global= kernel->workgroupSize();
        int local= kernel->localMemorySize();
        printf("dispatch( workgroups %d, local memory %d )\n", global, local);

        // execute le noyau openCL
        if(gk::dispatch(kernel, 1024, 16) < 0)
            printf("dispatch kernel '%s' error\n", kernel->name().c_str());
        
        // recupere le resultat et attent la fin du transfert
        float tmp[1000];
        b->get(0, sizeof(float [1000]), tmp, CL_TRUE);  // i/o bloquante
        
        // affiche le contenu du buffer resultat
        for(int i= 0; i < 32; i++)
            printf("%d: %f, ", i, tmp[i]);
        
        printf("done.\n");
        SDL_GL_SwapBuffers();
        return 0;
    }
    
};

int main( int argc, char **argv )
{
    CLTuto app;
    app.run();
    
    return 0;
}

