
#ifndef _GK_PTN_TRIANGLE_H
#define _GK_PTN_TRIANGLE_H

#include "Geometry.h"
#include "Transform.h"
#include "PNTriangle.h"

namespace gk {
    
//! representation d'un triangle 'geometrique'.
struct PTNTriangle : public PNTriangle
{
    Point2 ta, tb, tc;
    
    //! constructeur par defaut.
    PTNTriangle( ) 
        :
        PNTriangle()
    {}
    
    //! construit un triangle connaissant ses 3 sommets.
    PTNTriangle( 
        const Point& _a, const Normal& _na, const Point2& _ta,
        const Point& _b, const Normal& _nb, const Point2& _tb,
        const Point& _c, const Normal& _nc, const Point2& _tc )
        :
        PTNTriangle(_a, _na, _b, _nb, _c, _nc),
        ta(_ta), tb(_tb), tc(_tc)
    {}
    
    //! destructeur.
    ~PTNTriangle( ) {}
    
    //! renvoie un pntriangle transforme par 't'.
    PTNTriangle transform( const Transform& t )
    {
        return PTNTriangle( 
            t(a), t(na), ta, 
            t(b), t(nb), tb, 
            t(c), t(nc), tc );
    }
    
    //! renvoie le triangle geometrique
    Triangle getBaseTriangle( )
    {
        return Triangle(a, b, c);
    }
    
    //! renvoie le pn triangle.
    Triangle getPNTriangle( )
    {
        return Triangle(a, na, b, nb, c, nc);
    }
};

}
#endif
