
#ifndef _GLTEXTURE2DIO_H
#define _GLTEXTURE2DIO_H

#include "IOManager.h"
#include "ImageIO.h"
#include "GL/TPTexture.h"


namespace gk {

//! manager pour importer des GLColorTexture / GLHDRTexture.
class GLTexture2DIO : public IOManager<GLTexture2D>
{
    // non copyable
    GLTexture2DIO( const GLTexture& );
    GLTexture2DIO& operator=( const GLTexture& );
    
    // private default constructor, singleton
    GLTexture2DIO( )
        :
        IOManager<GLTexture2D>()
    {}
    
    ~GLTexture2DIO( )
    {
        // detruire les ressources GL, ~IOManager() detruit les objets.
        for(names_map_type::iterator 
            i= m_names_map.begin(); i != m_names_map.end(); ++i)
            i->second->releaseGLResource();
    }
    
public:
    //! importe la GLTexture 'name' a partir du ficher 'filename'
    static
    GLTexture2D *read( const int unit, const std::string& filename, const std::string& name= "" )
    {
        // importer le fichier, si necessaire
        GLTexture2D *gtexture= manager().find(filename, name);
        if(gtexture != NULL)
            return gtexture;
        
        // determiner le type HDR / Color de l'image
        if(ImageIO::isColorFile(filename))
        {
            Image *image= ImageIO::read(filename, name);
            if(image == NULL)
            {
                printf("failed '%s' color image\n", filename.c_str());
                return NULL;
            }
            
            // cree la GLTexture 'directement' sans utiliser GLManager / GLContext, l'objet ne doit etre gere que par un seul manager !!
            gtexture= new GLTexture2D(unit, image);
            if(gtexture->createGLResource() < 0)
            {
                delete gtexture;
                gtexture= NULL;
            }
        }
        else if(HDRImageIO::isHDRFile(filename))
        {
            HDRImage *image= HDRImageIO::read(filename, name);
            if(image == NULL)
            {
                printf("failed '%s' hdr image\n", filename.c_str());
                return NULL;
            }
            
            // cree la GLTexture 'directement' sans utiliser GLManager / GLContext, l'objet ne doit etre gere que par un seul manager !!
            gtexture= new GLTexture2D(unit, image);
            if(gtexture->createGLResource() < 0)
            {
                delete gtexture;
                gtexture= NULL;
            }
        }
        
        // reference le gl mesh avec le manager
        return manager().insert(gtexture, filename, name);        
    }
    
    static
    GLTexture2DIO& manager( )  // singleton
    {
        static GLTexture2DIO manager;
        return manager;
    }    
};

}

#endif
