
#ifndef _GLMANAGER_H
#define _GLMANAGER_H

#include <string>
#include <map>
#include <vector>

namespace gk {

//! manager pour les ressources openGL crees directement par l'application.
template< class Object >
class GLManager
{
    typedef std::map<std::string, int> name_map_type;
    name_map_type m_names_map;
    
    //~ typedef std::map<Object *, int> object_map_type;
    //~ object_map_type m_objects_map;
    
    std::vector<Object *> m_objects;

    //! non copyable.
    GLManager( const GLManager& );
    //! non copyable.
    GLManager& operator=( const GLManager& );
    
    //! constructeur.
    GLManager( )
        :
        m_names_map(),
        m_objects()
    {}
    
    //! destructeur.
    virtual ~GLManager( )
    {
        const int n= (int) m_objects.size();
        for(int i= 0; i < n; i++)
        {
            if(m_objects[i] == NULL)
                continue;
            
            // libere les ressources openGL
            m_objects[i]->releaseGLResource();
            // et detruit l'objet
            delete m_objects[i];
        }
    }
    
public:
    //! reference un nouvel objet nomme.
    Object *insert( Object *object, const std::string& name= "" )
    {
        if(name.empty() == false)
            // n'insere que les objets nommes dans la map.
            m_names_map.insert( std::make_pair(name, m_objects.size()) );
        
        //~ m_objects_map.insert( std::make_pair(object, m_objects.size()) );
        m_objects.push_back(object);
        return object;
    }
    
    //! recherche un objet nomme.
    Object *find( const std::string& name )
    {
        typename name_map_type::iterator found= m_names_map.find(name);
        if(found == m_names_map.end())
            return NULL;
        
        return m_objects[found->second];
    }
    
    //~ //! detruit un objet nomme.
    //~ int release( const std::string& name )
    //~ {
        //~ typename name_map_type::iterator found= m_names_map.find(name);
        //~ if(found == m_names_map.end())
            //~ return -1;
        
        //~ m_names_map.erase(found);
        //~ // libere les ressources openGL, de-reference l'objet
        //~ Object *object= m_objects[found->second];
        //~ if(object == NULL)
            //~ return -1;
        
        //~ object->releaseGLResource();
        //~ delete object;
        //~ m_objects[found->second]= NULL;
        //~ return 0;
    //~ }
    
    //~ //! detruit un objet.
    //~ int release( const Object *object )
    //~ {
        //~ if(object == NULL)
            //~ return -1;
        
        //~ typename object_map_type::iterator found= m_objects_map.find(object);
        //~ if(found == m_objects_map.end())
            //~ return -1;
        
        //~ m_objects_map.erase(found);
        //~ // libere les ressources openGL, de-reference l'objet
        //~ object->releaseGLResource();
        //~ delete object;
        //~ m_objects[found->second]= NULL;
        //~ return 0;
    //~ }
    
    static
    GLManager& manager( )
    {
        static GLManager manager;
        return manager;
    }
};

}       // namespace

#endif
