
#ifndef _TP_SAMPLER_H
#define _TP_SAMPLER_H

#include "GL/GLPlatform.h"
#include "GLResource.h"


namespace gk {

class GLSampler : public GLResource
{
    // non copyable
    GLSampler( const GLSampler& );
    GLSampler& operator= ( const GLSampler& );
    
public:
    GLSampler( )
        :
        GLResource()
    {
        glGenSamplers(1, &m_name);
    }

    virtual ~GLSampler( )
    {
        glDeleteSamplers(1, &m_name);
    }

    int createGLResource( )
    {
        return (m_name != 0) ? 0 : -1;
    }
    
    int releaseGLResource( )
    {
        return (m_name != 0) ? 0 : -1;
    }
};

class GLNearestSampler : public GLSampler
{
public:
    GLNearestSampler( )
        :
        GLSampler()
    {
        if(m_name == 0)
            return;
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_BORDER);
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_BORDER);
        //~ glSamplerParameteri(m_name, GL_TEXTURE_MIN_FILTER, GL_NEAREST_MIPMAP_NEAREST);
        glSamplerParameteri(m_name, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
        glSamplerParameteri(m_name, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
    }
    
    ~GLNearestSampler( ) {}
};

class GLLinearSampler : public GLSampler
{
public:
    GLLinearSampler( )
        :
        GLSampler( )
    {
        if(m_name == 0)
            return;
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_BORDER);
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_BORDER);
        glSamplerParameteri(m_name, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
        glSamplerParameteri(m_name, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    }

    ~GLLinearSampler( ) {}
};

class GLAnisotropicSampler : public GLSampler
{
public:
    GLAnisotropicSampler( const float filter )
        :
        GLSampler( )
    {
        if(m_name == 0)
            return;
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_BORDER);
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_BORDER);
        glSamplerParameterf(m_name, GL_TEXTURE_MAX_ANISOTROPY_EXT, filter);
        glSamplerParameteri(m_name, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
        glSamplerParameteri(m_name, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    }
    
    ~GLAnisotropicSampler() {}
};

class GLDepthSampler : public GLSampler
{
public:
    GLDepthSampler( )
        :
        GLSampler()
    {
        if(m_name == 0)
            return;
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
        glSamplerParameteri(m_name, GL_TEXTURE_COMPARE_MODE, GL_NONE);
        glSamplerParameteri(m_name, GL_TEXTURE_MIN_FILTER, GL_NEAREST_MIPMAP_NEAREST);
        //~ glSamplerParameteri(m_name, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
        glSamplerParameteri(m_name, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
    }
};

}

#endif
