
#include "GL/TPShaderProgram.h"
#include "GL/TPProgramName.h"


namespace gk {  

#ifndef GK_OPENGL4
int setSamplerUniform( const ProgramSampler& sampler, const int unit )
{
    if(!sampler.isValid())
        return -1;

    glUniform1i(sampler.location(), unit);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const unsigned int x )
{
    if(!uniform.isValid())
        return -1;

    glUniform1ui(uniform.location(), x);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const unsigned int x, const unsigned int y )
{
    if(!uniform.isValid())
        return -1;

    glUniform2ui(uniform.location(), x, y);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const unsigned int x, const unsigned int y, const unsigned int z )
{
    if(!uniform.isValid())
        return -1;

    glUniform3ui(uniform.location(), x, y, z);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const unsigned int x, const unsigned int y, const unsigned int z, const unsigned int w )
{
    if(!uniform.isValid())
        return -1;

    glUniform4ui(uniform.location(), x, y, z, w);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const int x )
{
    if(!uniform.isValid())
        return -1;

    glUniform1i(uniform.location(), x);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const int x, const int y )
{
    if(!uniform.isValid())
        return -1;

    glUniform2i(uniform.location(), x, y);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const int x, const int y, const int z )
{
    if(!uniform.isValid())
        return -1;

    glUniform3i(uniform.location(), x, y, z);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const int x, const int y, const int z, const int w )
{
    if(!uniform.isValid())
        return -1;

    glUniform4i(uniform.location(), x, y, z, w);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const float x )
{
    if(!uniform.isValid())
        return -1;

    glUniform1f(uniform.location(), x);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const float x, const float y )
{
    if(!uniform.isValid())
        return -1;

    glUniform2f(uniform.location(), x, y);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const float x, const float y, const float z )
{
    if(!uniform.isValid())
        return -1;

    glUniform3f(uniform.location(), x, y, z);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const float x, const float y, const float z, const float w )
{
    if(!uniform.isValid())
        return -1;

    glUniform4f(uniform.location(), x, y, z, w);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const float *m, const GLboolean transpose )
{
    if(!uniform.isValid())
        return -1;

    glUniformMatrix4fv(uniform.location(), 1, transpose, m);
    return 0;
}
#endif

#ifdef GK_OPENGL4
int setSamplerUniform( const ProgramSampler& sampler, const int unit )
{
    if(!sampler.isValid())
        return -1;

    glProgramUniform1i(sampler.program()->name(), sampler.location(), unit);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const unsigned int x )
{
    if(!uniform.isValid())
        return -1;

    glProgramUniform1ui(uniform.program()->name(), uniform.location(), x);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const unsigned int x, const unsigned int y )
{
    if(!uniform.isValid())
        return -1;

    glProgramUniform2ui(uniform.program()->name(), uniform.location(), x, y);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const unsigned int x, const unsigned int y, const unsigned int z )
{
    if(!uniform.isValid())
        return -1;

    glProgramUniform3ui(uniform.program()->name(), uniform.location(), x, y, z);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const unsigned int x, const unsigned int y, const unsigned int z, const unsigned int w )
{
    if(!uniform.isValid())
        return -1;

    glProgramUniform4ui(uniform.program()->name(), uniform.location(), x, y, z, w);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const int x )
{
    if(!uniform.isValid())
        return -1;

    glProgramUniform1i(uniform.program()->name(), uniform.location(), x);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const int x, const int y )
{
    if(!uniform.isValid())
        return -1;

    glProgramUniform2i(uniform.program()->name(), uniform.location(), x, y);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const int x, const int y, const int z )
{
    if(!uniform.isValid())
        return -1;

    glProgramUniform3i(uniform.program()->name(), uniform.location(), x, y, z);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const int x, const int y, const int z, const int w )
{
    if(!uniform.isValid())
        return -1;

    glProgramUniform4i(uniform.program()->name(), uniform.location(), x, y, z, w);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const float x )
{
    if(!uniform.isValid())
        return -1;

    glProgramUniform1f(uniform.program()->name(), uniform.location(), x);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const float x, const float y )
{
    if(!uniform.isValid())
        return -1;

    glProgramUniform2f(uniform.program()->name(), uniform.location(), x, y);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const float x, const float y, const float z )
{
    if(!uniform.isValid())
        return -1;

    glProgramUniform3f(uniform.program()->name(), uniform.location(), x, y, z);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const float x, const float y, const float z, const float w )
{
    if(!uniform.isValid())
        return -1;

    glProgramUniform4f(uniform.program()->name(), uniform.location(), x, y, z, w);
    return 0;
}

int setUniform( const ProgramUniform& uniform, const float *m, const GLboolean transpose )
{
    if(!uniform.isValid())
        return -1;

    glProgramUniformMatrix4fv(uniform.program()->name(), uniform.location(), 1, transpose, m);
    return 0;
}
#endif


}
