
#ifndef _GKEFFECT_SHADER_MANAGER_H
#define _GKEFFECT_SHADER_MANAGER_H

#include <string>

#include "Name.h"
#include "Effect.h"
#include "ShaderManager.h"


namespace gk {

//! creation simplifiee d'un shader program a partir d'un script.
class  EffectShaderManager 
{
    Effect *m_effect;
    std::map<Name, GLShaderProgram *> m_programs_map;
    
    // non copyable.
    EffectShaderManager( );
    EffectShaderManager( const EffectShaderManager& );
    EffectShaderManager& operator= ( const EffectShaderManager& );
    
public:
    //! constructeur. charge le script.
    EffectShaderManager( const std::string& effect );

    //! constructeur. reference un script deja charge.
    EffectShaderManager( Effect *effect );
    
    //! destructeur.
    ~EffectShaderManager( );

    //! insere un shader program existant dans le manager.
    GLShaderProgram *insert( GLShaderProgram *program, const Name& name )
    {
        m_programs_map.insert( std::make_pair(name, program) );
        return program;
    }

    //! retrouve un shader program. renvoie eventuellement NULL si le programe n'existe pas.
    GLShaderProgram *program( const Name& name )
    {
        std::map<Name, GLShaderProgram *>::iterator found= m_programs_map.find(name);
        if(found == m_programs_map.end())
            return NULL;
        else
            return found->second;
    }

    //! retouve un shader program. renvoie eventuellement NULL si le programe n'existe pas.
    GLShaderProgram *operator[] ( const Name &name )
    {
        return program(name);
    }
    
    //! cree un shader program opengl > 2 a partir d'une section complete.
    GLShaderProgram *createShaderProgram( const std::string& program_key )
    {
        return createShaderProgram2(program_key);
    }
    
    //! cree un shader program opengl > 2 a partir des sections de chaque shader.
    GLShaderProgram *createShaderProgram( 
        const TextValue& vertex_key, 
        const TextValue& fragment_key )
    {
        return createShaderProgram2(vertex_key, fragment_key);
    }
    
    //! cree un shader program opengl > 2 a partir d'une section complete.
    GLShaderProgram *createShaderProgram2( const std::string& program_key );
    
    //! cree un shader program opengl > 2 a partir des sections de chaque shader.
    GLShaderProgram *createShaderProgram2( 
        const TextValue& vertex_key, 
        const TextValue& fragment_key );
    
#if defined GK_OPENGL3 || defined GK_OPENGL4    
    //! cree un shader program opengl > 3 a partir d'une section complete.
    GLShaderProgram *createShaderProgram3( const std::string& program_key );
    
    //! cree un shader program opengl > 3 a partir des sections de chaque shader.
    GLShaderProgram *createShaderProgram3( 
        const TextValue& vertex_key,
        const TextValue& geometry_key,
        const TextValue& fragment_key );
#endif
    
#ifdef GK_OPENGL4    
    //! cree un shader program opengl > 4 a partir d'une section complete.
    GLShaderProgram *createShaderProgram4( const std::string& program_key );
    
    //! cree un shader program opengl > 4 a partir des sections de chaque shader.
    GLShaderProgram *createShaderProgram4( 
        const TextValue& vertex_key,
        const TextValue& control_key,
        const TextValue& evaluation_key,
        const TextValue& goemetry_key,
        const TextValue& fragment_key );
#endif
};

}

#endif
