
#ifndef _CLRESOURCE_H
#define _CLRESOURCE_H


namespace gk {

//! classe de base des resources openCL, referencees par l'application, proprietes du contexte openCL. cf \ref CLResource, gestion des objets openCL.
class CLResource
{
    //! non copyable.
    CLResource( const CLResource& );
    //! non copyable.
    CLResource& operator=( const CLResource& );
    
public:
    CLResource( ) {}
    virtual ~CLResource( ) {}
    
    //! comportement par defaut, necessaire pour GLManager, a redefinir dans les classes derivees.
    int createCLResource( ) 
    {
        return 0;
    }
    
    //! comportement par defaut, necessaire pour GLManager, a redefinir dans les classes derivees.
    int releaseCLResource( )
    {
        return 0;
    }
};

} // namespace

#endif
