#ifndef _MODEL_PRIVATE_H
#define _MODEL_PRIVATE_H

#include <assert.h>
#include "model.h"

static inline int model_get_faces_n(MODEL *model)
{
    assert(model!=NULL);
    
    return model->faces_n;
}

static inline FACE *model_get_face_ptr(MODEL *model, int f)
{
    assert(model!=NULL);
    assert(f>=0 && f < model->faces_n);
    
    return &model->faces[f];
}

static inline int face_get_vertex_n(FACE *face)
{
    assert(face!=NULL);
    
    return face->n;
}

static inline int face_get_material_id(FACE *face)
{
    assert(face!=NULL);
    return face->mat;
}

static inline MATERIAL *model_get_material_ptr(MODEL *model, int m)
{
    assert(model!=NULL);
    assert(m>=0 && m < model->mat_n);
    
    return &model->mat[m];
}

static inline MATERIAL *model_face_get_material_ptr(MODEL *model, FACE *face)
{
    return model_get_material_ptr(model, face_get_material_id(face));
}

static inline float *model_get_vertex_ptr(MODEL *model, int a)
{
    assert(model!=NULL);
    assert(a>=0 && a < model->attr_n);
    
    return model->v[model->attr[a][gl_vertex]];
}

static inline float *model_face_get_vertex_ptr(MODEL *model, FACE *face, int v)
{
    int attr;
    
    assert(model!=NULL);
    assert(face!=NULL);
    assert(v>=0 && v < face->n);
    
    attr= face->attr + v;
    return model_get_vertex_ptr(model, attr);
}

static inline int model_face_get_edge(MODEL *model, FACE *face, int e, VEC *edge)
{
    float *v0, *v1;
    
    v0= model_face_get_vertex_ptr(model, face, e);
    v1= model_face_get_vertex_ptr(model, face, (e+1) % face->n);
    
    vec3_sub(*edge, v1, v0);
    return 0;
}

static inline int model_face_get_inner_edge(MODEL *model, FACE *face, int e, VEC *edge)
{
    float *v0, *v1;
    
    v0= model_face_get_vertex_ptr(model, face, 0);
    v1= model_face_get_vertex_ptr(model, face, e);
    
    vec3_sub(*edge, v1, v0);
    return 0;
}

static inline int face_get_norm_id(FACE *face)
{
    assert(face!=NULL);
    
    return face->norm;
}

static inline float *model_get_norm_ptr(MODEL *model, int n)
{
    assert(model!=NULL);
    assert(n>=0 && n<model->norm_n);
    
    return model->norm[n];
}

static inline float *model_face_get_norm_ptr(MODEL *model, FACE *face)
{
    return model_get_norm_ptr(model, face_get_norm_id(face));
}

#endif
