/*
    echantillonnage de points ou de directions
 */

#include <stdlib.h>
#include <math.h>

#include "vec.h"
#include "model.h"
#include "render.h"
#include "dpoint.h"

/* mesure sur les aires */

static void quad_sample_point(RENDER *render, int face_id, DPOINT *point, float *pa)
{
    MODEL *model;
    FACE *face;
    VEC p;
    VEC e1, e2;
    float u1, u2;

    u1= (float) drand48();
    u2= (float) drand48();
    
    model= render_get_model(render);
    face= model_get_face_ptr(model, face_id);
    model_face_get_edge(model, face, 0, &e1);
    model_face_get_edge(model, face, face_get_vertex_n(face) -1, &e2);
    vec3_neg(e2, e2);
    
    vec3_const_mul(e1, u1, e1);
    vec3_const_mul(e2, u2, e2);
    
    vec3_add(p, model_face_get_vertex_ptr(model, face, 0), e1);
    vec3_add(p, p, e2);

    dpoint_init_face_point(model, point, face_id, p);
    *pa= 1.f / render_face_get_area(render, face_id);
}

static void triangle_sample_point(RENDER *render, int face_id, DPOINT *point, float *pa)
{
    MODEL *model;
    FACE *face;
    VEC p;
    float a, b, c;
    float u1, u2;
    
    u1= sqrtf((float) drand48());
    u2= (float) drand48();
    
    a= 1.f - u1;
    b= (1.f - u2) * u1;
    c= u2 * u1;
    
    model= render_get_model(render);
    face= model_get_face_ptr(model, face_id);
    vec3_const_mul(p, a, model_face_get_vertex_ptr(model, face, 0));
    vec3_add_mul_const(p, p, b, model_face_get_vertex_ptr(model, face, 1));
    vec3_add_mul_const(p, p, c, model_face_get_vertex_ptr(model, face, 2));

    dpoint_init_face_point(model, point, face_id, p);
    *pa= 1.f / render_face_get_area(render, face_id);
}

void render_face_sample_point(RENDER *render, int face_id, DPOINT *point, float *pa)
{
    /* choisit un point uniformement dans une face
     */
    
    MODEL *model;
    FACE *face;
    int n;
    
    model= render_get_model(render);
    face= model_get_face_ptr(model, face_id);
    n=face_get_vertex_n(face);
    if(n==3)
        triangle_sample_point(render, face_id, point, pa);
    else if(n==4)
        quad_sample_point(render, face_id, point, pa);
    else
        *pa= 0.f;
   /* trianguler la face, choisir un triangle par importance 
        et choisir un point dans le triangle
    */
 }

void render_sample_light(RENDER *render, int *light_id, DPOINT *point, float *pa)
{
    /* choisit un point uniformement sur les sources de lumieres
     */
    
    float u, uu;
    int i;
    
    u= (float) drand48();
    uu= u * render->lights_total_area;
    for(i= 0; i < render->lights_n; i++)
    {
        uu-= render->lights[i].area;
        
        if(uu < EPSILON)
            break;
    }

    if(i >= render->lights_n)
        i= render->lights_n -1;
    
    render_face_sample_point(render, render->lights[i].face_id, point, pa);
    *light_id= i;
    *pa= 1.f / render->lights_total_area;
    // par definition : 1 / render->lights_total_area
}

void render_sample_light_Le(RENDER *render, int *light_id, DPOINT *point, float *pa)
{
    /* choisit un point sur les sources de lumieres proportionnellement a l'energie emise 
     */
    
    float u, uu;
    int i;
    
    u= (float) drand48();
    uu= u * render->lights_total_emission;
    for(i= 0; i < render->lights_n; i++)
    {
        uu-= render->lights[i].emission * render->lights[i].area;
        
        if(uu < EPSILON)
            break;
    }

    if(i >= render->lights_n)
        i= render->lights_n -1;
    
    render_face_sample_point(render, render->lights[i].face_id, point, pa);
    *light_id= i;
    *pa= render->lights[i].emission / render->lights_total_emission;
}

void render_sample_face(RENDER *render, int *face_id, float *pa)
{
    /* choisit une face proportionnellement a son aire
     */
    
    float u, uu;
    int i;
    
    u= (float) drand48();
    uu= u * render->faces_total_area;
    for(i= 0; i < render->faces_area_n; i++)
    {
        uu-= render->faces_area[i];
        
        if(uu < EPSILON)
            break;
    }

    if(i >= render->faces_area_n)
        i= render->faces_area_n -1;
    
    *face_id= i;
    *pa= render->faces_area[i] / render->faces_total_area;
}

void render_sample(RENDER *render, int *face_id, DPOINT *point, float *pa)
{
    /* choisit un point uniformement sur les surfaces des objets de la scene
     */
    
    MODEL *model;
    FACE *face;
    float u, uu;
    int i;
    
    u= (float) drand48();
    uu= u * render->faces_total_area;
    for(i= 0; i < render->faces_area_n; i++)
    {
        uu-= render->faces_area[i];
        
        if(uu < EPSILON)
            break;
    }

    if(i >= render->faces_area_n)
        i= render->faces_area_n -1;
    
    render_face_sample_point(render, i, point, pa);
   *pa= *pa * render->faces_area[i] / render->faces_total_area;
}

