#ifndef _RENDER_H
#define _RENDER_H

#include "model.h"
#include "camera.h"
#include "dpoint.h"

typedef struct
{
    MODEL *model;
    int face_id;

    float area;
    float emission;
} LIGHT;

typedef struct
{
    CAMERA camera;
    MODEL *model;

    // sources de lumiere 
    char *light_material_name;
    int light_material_id;
    LIGHT *lights;
    int lights_size;
    int lights_n;
    
    float lights_total_emission;
    float lights_total_area;
   
    // modele
    float *faces_area;
    int faces_area_size;
    int faces_area_n;
    float faces_total_area;
    
    // stats
    int rays_n;
    int rays_camera_n;
    int rays_light_n;
} RENDER;

#define RENDER_LIGHT_MORE 4
#define RENDER_FACE_MORE MODEL_FACE_MORE

/* */
extern RENDER *render_new(MODEL *scene, char *light_material_name);
extern void render_free(RENDER *render);

/* */
extern MODEL *render_get_model(RENDER *render);
extern CAMERA *render_get_camera(RENDER *render);

/* light interface */
extern int render_material_is_light(RENDER *render, int material_id);
extern float render_get_light_emission(RENDER *render, int light_id, DPOINT *p, DPOINT *q);
extern float render_get_Le(RENDER *render, DPOINT *p);

/* face interface */
extern float render_face_get_area(RENDER *render, int face_id);


/* sample interface */
extern void render_sample_light_Le(RENDER *render, int *light_id, DPOINT *point, float *pa);



#endif
