#ifndef _RAY_H
#define _RAY_H

#include "vec.h"
#include "model.h"

typedef struct ray
{
    MODEL *model;
    
    VEC origin;
    VEC direction;
    float tmin, tmax;
    float t;
    int hit;
} RAY;

struct dpoint;
extern int ray_intersect(RAY *ray, struct dpoint *point);
extern int ray_occlusion(RAY *ray);
extern void ray_get_origin(RAY *ray, struct dpoint *point);

extern void ray_zero(MODEL *model, RAY *ray);
extern void ray_init_direction(MODEL *model, RAY *ray, VEC origin, VEC direction);
extern void ray_init_occlusion(MODEL *model, RAY *ray, VEC origin, VEC destination);

#endif

