/*
    main.c
    
    squelette d'utilisation de rendertoy
    
    questions ??
    mailto:jciehl@bat710.univ-lyon1.fr
    
    decembre 2006
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "vec.h"
#include "model.h"
#include "maya_obj.h"
#include "off.h"
#include "img.h"
#include "hdr.h"
#include "camera.h"
#include "ray.h"
#include "dpoint.h"
#include "render.h"

/* ecrire un pixel dans une image */
void img_set_pix(IMG *img, int x, int y, float r, float v, float b)
{
    unsigned int pix;
    assert(img!=NULL);
    assert(x>=0 && x < img->largeur);
    assert(y>=0 && y < img->hauteur);
    
    pix= y * img->alignement + x * img->channels;
    img->dataf[pix]= r;
    img->dataf[pix +1]= v;
    img->dataf[pix +2]= b;
}

int main(int argc, char **argv)
{
    IMG *img;
    MODEL *model;
    RENDER *render;
    
    model= NULL;
    if(argc > 1)
    {
        /* charge le modele .obj ou .off
         */
        if((model_is_obj(argv[1])==0 
            && model_load_obj(&model, argv[1]) < 0)
        || (model_is_off(argv[1])==0 
            && model_load_off(&model, argv[1]) < 0))
        {
            printf("\n  -- unable to load model '%s'\n", argv[1]);
            return 1;
        }
    }
    if(model==NULL)
    {
        printf("\n -- unable to load model\n");
        return 1;
    }
    
    /* cree le contexte de calcul
     */
    render= render_new(model, "diffuseLuminaire1SG");
    
    /* cree l'image resultat
     */
    img= new_img_datafloat(256, 256);
    
    /* placer la camera dans le repere de la scene :
        a completer 
    
    int viewport[4];
    viewport[0]= 0;
    viewport[1]= 0;
    viewport[2]= img->largeur;
    viewport[3]= img->hauteur;
    
    render_camera_set_projection(render, viewport, model_matrix, projection_matrix);
    */
    
    /* calculer l'image :
        a completer 
    
    DPOINT p;
    RAY ray;
    int x, y;
    for(y= 0; y < img->hauteur; y++)
    {
        for(x= 0; x < img->largeur; x++)
        {
            render_camera_sample_ray(render, xf, yf, &ray);
            if(render_intersection(render, &ray, &p) < 0)
                // pas d'intersection : noir
            else
                // calculer la couleur du point
            img_set_pix(img, x, y, rouge, vert, bleu);
        }
    }
    
    */
    
    /* enregistre l'image resultat au format hdr
     */
    hdr_write(img, "render.hdr");
    
    /* fin
     */
    free_img(img);
    render_free(render);
    model_free(model);
    
    printf("\ndone.\n");
    return 0;
}
