#include <stdio.h>
#include <assert.h>
#include <math.h>

#include <GL/gl.h>

#include "vec.h"
#include "model.h"
#include "ray.h"
#include "camera.h"
#include "glmat.h"

void camera_set_projection_opengl(CAMERA *camera)
{
    glGetIntegerv(GL_VIEWPORT, camera->viewport);
    glGetFloatv(GL_MODELVIEW_MATRIX, camera->mvmatrix);
    glGetFloatv(GL_PROJECTION_MATRIX, camera->projmatrix);

    printf("camera_viewport(): %d %d %dx%d\n", 
        camera->viewport[0], camera->viewport[1], 
        camera->viewport[2], camera->viewport[3]);
    
    if(glmat_unproject_get_inversematrix(camera->inversemvmatrix, 
        camera->mvmatrix, camera->projmatrix)==0)
    {
        printf("\n -- singular projection matrix\n");
        // fix something
    }
}

void camera_set_projection(CAMERA *camera, int vp[4], float m[16], float p[16])
{
    /* definit les matrices de projection et de modele : attention format openGL
        (a modifier)
     */
    int i;
    assert(camera!=NULL);
    
    for(i= 0; i < 4; i++)
        camera->viewport[i]= vp[i];
    
    /* TODO : transposer les matrices ... */
    for(i= 0; i < 16; i++)
        camera->mvmatrix[i]= m[i];
    
    for(i= 0; i < 16; i++)
        camera->projmatrix[i]= p[i];
    
    if(glmat_unproject_get_inversematrix(camera->inversemvmatrix, 
        camera->mvmatrix, camera->projmatrix)==0)
    {
        printf("\n -- singular projection matrix\n");
        // fix something
    }
}

void camera_set_pos(CAMERA *camera, float x, float y, float z)
{
    assert(camera!=NULL);

    camera->pos[0]= x;
    camera->pos[1]= y;
    camera->pos[2]= z;
    camera->pos[3]= 1.f;
}

void camera_get_viewport(CAMERA *camera, int viewport[4])
{
    int i;
    
    assert(camera!=NULL);
    
    for(i= 0; i < 4; i++)
        viewport[i]= camera->viewport[i];
}

void camera_sample_pixel(CAMERA *camera, float x, float y, MODEL *model, RAY *ray)
{
    VEC near, far;
    VEC direction;

    glmat_unproject(x, y, 1.f, 
        camera->inversemvmatrix, 
        camera->viewport, 
        &far[0], &far[1], &far[2]);

    glmat_unproject(x, y, -1.f, 
        camera->inversemvmatrix, 
        camera->viewport, 
        &near[0], &near[1], &near[2]);
    
    vec3_sub(direction, far, near);
    vec3_norm(direction, direction);
    ray_init_direction(model, ray, near, direction);
}
