#ifndef _DPOINT_H
#define _DPOINT_H

#include "vec.h"
#include "model.h"

typedef struct dpoint
{
    MODEL *model;
    int face_id;

    VEC p;
    VEC u, v, w;
} DPOINT;

struct ray;

/* creation d'un point */
extern void dpoint_init(MODEL *model, DPOINT *point);
extern int dpoint_init_ray(MODEL *model, DPOINT *point, struct ray *ray);
extern void dpoint_init_face_point(MODEL *model, DPOINT *point, int face_id, VEC p);

/* transformation d'un vecteur local au point dans le repere global de la scene */
extern void dpoint_transform_vec(DPOINT *point, VEC local, VEC global);

/* trouver le point q visible de p dans la direction w */
int dpoint_trace_ray(DPOINT *point, VEC w, DPOINT *q);

/* verifier que p et q sont visibles */
int dpoint_visibility_ray(DPOINT *p, DPOINT *q);

/* */
extern MATERIAL *dpoint_get_material_ptr(DPOINT *point);
extern int dpoint_get_material_id(DPOINT *point);
extern float dpoint_brdf(DPOINT *point, VEC in, VEC out);
extern float dpoint_brdf_3points(DPOINT *o, DPOINT *p, DPOINT *q);

/* calcule le changement de mesure dW / dA entre 2 points */
extern float dpoint_get_dWdA(DPOINT *p, DPOINT *q);
/* calcule le couplage geometrique entre 2 points */
extern float dpoint_get_G(DPOINT *p, DPOINT *q);

/* determine le point q visible du point dans la direction w */
extern int dpoint_trace_ray(DPOINT *point, VEC w, DPOINT *q);

/* choisit une direction uniformement */
extern void dpoint_sample_direction(DPOINT *point, VEC w, float *pw);
/* determine la probabilite d'avoir genere la direction w suivant une loi uniforme */
extern float dpoint_weight_direction(DPOINT *point, VEC w);

/* choisit une direction proportionnelle au cosinus avec la normale du point */
extern void dpoint_sample_direction_cos(DPOINT *point, VEC w, float *pw);
/* determine la probabilite d'avoir genere la direction w suivant une 
    loi proportionnelle au cosinus avec la normale du point */
extern float dpoint_weight_direction_cos(DPOINT *point, VEC w);

/* choisit une direction proportionnelle a la brdf du point */
extern void dpoint_sample_direction_brdf(DPOINT *point, VEC w, float *pw);
/* determine la probabilite d'avoir genere la direction w suivant une 
    loi proportionnelle a la brdf du point */
extern float dpoint_weight_direction_brdf(DPOINT *point, VEC w);

/* trouve le point q visible dans une direction choisie uniformement */
extern int dpoint_sample(DPOINT *point, DPOINT *q, float *pa);
/* determine la probabilite d'avoir genere le point q suivant une distribution 
    de direction uniforme */
extern float dpoint_weight(DPOINT *point, DPOINT *q);

/* trouve le point q visible dans une direction choisie proportionnellement 
    au cosinus de la normale du point */
extern int dpoint_sample_cos(DPOINT *point, DPOINT *q, float *pa);
/* determine la probabilite d'avoir genere le point q suivant une distribution 
    proportionnelle au cosinus de la normale du point */
extern float dpoint_weight_cos(DPOINT *point, DPOINT *q);

/* trouve le point q visible dans une direction choisie proportionnellement 
    a la brdf du point */
extern int dpoint_sample_brdf(DPOINT *point, DPOINT *q, float *pa);
/* determine la probabilite d'avoir genere le point q suivant une distribution 
    proportionnelle a la brdf du point */ 
extern float dpoint_weight_brdf(DPOINT *point, DPOINT *q);

#endif

