#ifndef _CAMERA_H
#define _CAMERA_H

#include "vec.h"
#include "model.h"
#include "ray.h"

typedef struct
{
    float mvmatrix[16], projmatrix[16];
    float inversemvmatrix[16];
    float pos[4];
    int viewport[4];
} CAMERA;

extern void camera_set_projection(CAMERA *camera, int vp[4], float m[16], float p[16]);
extern void camera_set_projection_opengl(CAMERA *camera);
extern void camera_set_pos(CAMERA *camera, float x, float y, float z);
extern void camera_sample_pixel(CAMERA *camera, float x, float y,  MODEL *model, struct ray *ray);

extern void camera_get_viewport(CAMERA *camera, int viewport[4]);
#endif
