/*
	motion_testmain
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "motion.h"
#include "bvh.h"


void joint_print_binding(float v, int binding)
{
	printf("%f ", v);
	if(binding==JOINT_XROT)
		printf("X ");
	else if(binding==JOINT_YROT)
		printf("Y ");
	else if(binding==JOINT_ZROT)
		printf("Z ");
}

void joint_print(MFRAME *frame, int joint_id)
{
	VEC t;
	VEC r;
	int bindings[3];
	int i;
	
	while(joint_id!=-1)
	{
		if(frame->joints[joint_id].name!=NULL)
			printf("frame %d joint '%s'  ", frame->id, frame->joints[joint_id].name);
		else
			printf("frame %d joint 'noname' ( %d )  ", frame->id, joint_id);
	
		joint_get_offset(frame, joint_id, t);
		printf("  offset ( %f %f %f )\n", t[0], t[1], t[2]);
		joint_get_position(frame, joint_id, t);
		printf("    T ( %f %f %f )\n", t[0], t[1], t[2]);
		
		joint_get_orientation(frame, joint_id, r, bindings);
		printf("    R ( ");
			joint_print_binding(r[0], bindings[0]);
			joint_print_binding(r[1], bindings[1]);
			joint_print_binding(r[2], bindings[2]);
		printf(")");
		
		printf("\n");
		
		joint_print(frame, frame->joints[joint_id].child);
		joint_id= frame->joints[joint_id].next;
	}
}

void frame_print(MFRAME *frame)
{
	joint_print(frame, frame->root_id);
}


int main(int argc, char **argv)
{
	MOTION *motion;
	MFRAME frame;
	int i;
	
	if(argc!=2)
	{
		printf("usage : %s motion.bvh\n", argv[0]);
		return 0;
	}
	
	if(motion_load_bvh(&motion, argv[1]) < 0)
	{
		printf("failed.\n");
		return 1;
	}

	motion_print(motion);
	printf("time %f\n", motion_get_time(motion));

	//	
	motion_frame_init(&frame, motion);
	
	for(i= 0; motion_get_frame(&frame, motion, i)==0; i++)
	{
		printf("frame %d : time %f / %f\n", 
			motion_frame_get_id(&frame),
			motion_frame_get_time(&frame),
			motion_frame_get_motion_time(&frame));
		
		frame_print(&frame);
	}
	
	printf("stop\n");
	motion_frame_free(&frame, 0);
	motion_free(motion, 1);
	
	return 0;
}
