#ifndef _PROJECT_GLU_H
#define _PROJECT_GLU_H

#include <GL/gl.h>

/*
	gluPerspective
 */
extern void Perspective(GLdouble fovy, GLdouble aspect, GLdouble zNear, GLdouble zFar);
extern void Perspectivef(GLfloat fovy, GLfloat aspect, GLfloat zNear, GLfloat zFar);

/*
	gluLookAt
 */
extern void LookAt(GLdouble eyex, GLdouble eyey, GLdouble eyez, GLdouble centerx,
	GLdouble centery, GLdouble centerz, GLdouble upx, GLdouble upy,
	GLdouble upz);

extern void LookAtf(GLfloat eyex, GLfloat eyey, GLfloat eyez, GLfloat centerx,
	GLfloat centery, GLfloat centerz, GLfloat upx, GLfloat upy,
	GLfloat upz);

/*
	gluProject
 */
GLint Project(GLdouble objx, GLdouble objy, GLdouble objz, 
	const GLdouble modelMatrix[16], 
	const GLdouble projMatrix[16],
	const GLint viewport[4],
	GLdouble *winx, GLdouble *winy, GLdouble *winz);

GLint Projectf(GLfloat objx, GLfloat objy, GLfloat objz, 
	const GLfloat modelMatrix[16], 
	const GLfloat projMatrix[16],
	const GLint viewport[4],
	GLfloat *winx, GLfloat *winy, GLfloat *winz);

/*
	gluUnProject
 */
extern GLint UnProject(GLdouble winx, GLdouble winy, GLdouble winz,
	const GLdouble modelMatrix[16], 
	const GLdouble projMatrix[16],
	const GLint viewport[4],
	GLdouble *objx, GLdouble *objy, GLdouble *objz);

extern GLint UnProjectf(GLfloat winx, GLfloat winy, GLfloat winz,
	const GLfloat modelMatrix[16], 
	const GLfloat projMatrix[16],
	const GLint viewport[4],
	GLfloat *objx, GLfloat *objy, GLfloat *objz);


extern GLint UnProject4(GLdouble winx, GLdouble winy, GLdouble winz, GLdouble clipw,
	const GLdouble modelMatrix[16], 
	const GLdouble projMatrix[16],
	const GLint viewport[4],
	GLclampd nearVal, GLclampd farVal,		    
	GLdouble *objx, GLdouble *objy, GLdouble *objz, GLdouble *objw);

extern GLint UnProject4f(GLfloat winx, GLfloat winy, GLfloat winz, GLfloat clipw,
	const GLfloat modelMatrix[16], 
	const GLfloat projMatrix[16],
	const GLint viewport[4],
	GLclampf nearVal, GLclampd farVal,		    
	GLfloat *objx, GLfloat *objy, GLfloat *objz, GLfloat *objw);
	
/*
	UnProjectInverseMvMatrix
 */
extern GLint UnProject_getInverseMvMatrixf(GLfloat inverse_mvMatrix[16], 
	const GLfloat modelMatrix[16], 
	const GLfloat projMatrix[16]);

extern GLint UnProjectInverseMvMatrixf(GLfloat winx, GLfloat winy, GLfloat winz,
	const GLfloat inverse_mvMatrix[16], 
	const GLint viewport[4],
	GLfloat *objx, GLfloat *objy, GLfloat *objz);

/*
	gluPickMatrix
 */
extern void PickMatrix(GLdouble x, GLdouble y, GLdouble deltax, GLdouble deltay, GLint viewport[4]);
extern void PickMatrixf(GLfloat x, GLfloat y, GLfloat deltax, GLfloat deltay, GLint viewport[4]);


/*
	matrix
 */
extern void MakeIdentityd(GLdouble m[16]);
extern void MakeIdentityf(GLfloat m[16]);

extern void Normalizef(float v[3]);

extern void Crossf(float v1[3], float v2[3], float result[3]);

extern void MultMatrixVecd(const GLdouble matrix[16], const GLdouble in[4], GLdouble out[4])
extern void MultMatrixVecf(const GLfloat matrix[16], const GLfloat in[4], GLfloat out[4]);

extern void MultMatricesd(const GLdouble a[16], const GLdouble b[16], GLdouble r[16]);
extern void MultMatricesf(const GLfloat a[16], const GLfloat b[16], GLfloat r[16]);

extern int InvertMatrixd(const GLdouble src[16], GLdouble inverse[16]);
extern int InvertMatrixf(const GLfloat src[16], GLfloat inverse[16]);


#endif

