#ifndef _VEC_H
#define _VEC_H

typedef float VEC[4];
typedef float VEC3[3];
typedef float VEC2[2];

#if 0
extern void vec3_copy(float dest[3], float v[3]);
extern void vec3_norm(float v[3]);
extern void vec3_cross(float dest[3], float v1[3], float v2[3]);
extern float vec3_dot(float v1[3], float v2[3]);
extern void vec3_sub(float dest[3], float v1[3], float v2[3]);
extern void vec3_add_mul_const(float dest[3], float p[3], float k, float v[3]);

#else

#define vec3_zero(v) \
{ \
	(v)[0]= 0.f; \
	(v)[1]= 0.f; \
	(v)[2]= 0.f; \
}

#define vec3_copy(dest, v) \
{ \
	(dest)[0]= (v)[0]; \
	(dest)[1]= (v)[1]; \
	(dest)[2]= (v)[2]; \
}

#define vec2_zero(v) \
{ \
	(v)[0]= 0.f; \
	(v)[1]= 0.f; \
}

#define vec2_copy(dest, v) \
{ \
	(dest)[0]= (v)[0]; \
	(dest)[1]= (v)[1]; \
}

#define vec_zero(v) \
{ \
	(v)[0]= 0.f; \
	(v)[1]= 0.f; \
	(v)[2]= 0.f; \
	(v)[3]= 0.f; \
}

#define vec_copy(dest, v) \
{ \
	(dest)[0]= (v)[0]; \
	(dest)[1]= (v)[1]; \
	(dest)[2]= (v)[2]; \
	(dest)[3]= (v)[3]; \
}

#define vec3_neg(dest, v) \
{ \
	(dest)[0]= -(v)[0]; \
	(dest)[1]= -(v)[1]; \
	(dest)[2]= -(v)[2]; \
}

#define vec3_dot(v1, v2) ((v1)[0]*(v2)[0] + (v1)[1]*(v2)[1] + (v1)[2]*(v2)[2])

#define vec3_length2(v) vec3_dot(v, v)

#define vec3_length(v) sqrt(vec3_dot(v, v))

#define vec3_norm(dest, v) \
{ \
	float d= 1. / vec3_length(v); \
	vec3_const_mul(dest, d, v) \
}

#define vec3_cross(dest, v1, v2) \
{ \
	(dest)[0]= (v1)[1]*(v2)[2] - (v1)[2]*(v2)[1]; \
	(dest)[1]= (v1)[2]*(v2)[0] - (v1)[0]*(v2)[2]; \
	(dest)[2]= (v1)[0]*(v2)[1] - (v1)[1]*(v2)[0]; \
}

#define vec3_sub(dest, v1, v2) \
{ \
	(dest)[0]= (v1)[0] - (v2)[0]; \
	(dest)[1]= (v1)[1] - (v2)[1]; \
	(dest)[2]= (v1)[2] - (v2)[2]; \
}

#define vec3_add(dest, v1, v2) \
{ \
	(dest)[0]= (v1)[0] + (v2)[0]; \
	(dest)[1]= (v1)[1] + (v2)[1]; \
	(dest)[2]= (v1)[2] + (v2)[2]; \
}

#define vec3_mul(dest, v1, v2) \
{ \
	(dest)[0]= (v1)[0] * (v2)[0]; \
	(dest)[1]= (v1)[1] * (v2)[1]; \
	(dest)[2]= (v1)[2] * (v2)[2]; \
}

#define vec3_add_mul_const(dest, p, k, v) \
{ \
	(dest)[0]= (p)[0] + (k)*(v)[0]; \
	(dest)[1]= (p)[1] + (k)*(v)[1]; \
	(dest)[2]= (p)[2] + (k)*(v)[2]; \
}

#define vec3_const_mul(dest, k, v) \
{ \
	(dest)[0]= (k)*(v)[0]; \
	(dest)[1]= (k)*(v)[1]; \
	(dest)[2]= (k)*(v)[2]; \
}

#define vec3_mirror(dest, n, v) \
{ \
	float d= 2. * vec3_dot(n, v); \
	(dest)[0]= d*(n)[0] - (v)[0]; \
	(dest)[1]= d*(n)[1] - (v)[1]; \
	(dest)[2]= d*(n)[2] - (v)[2]; \
	vec3_norm(dest, dest); \
}

#endif

#endif
