#ifndef _MODEL_H
#define _MODEL_H

#include "vec.h"
typedef VEC VERTEX;
typedef VEC VERTEXN;
typedef VEC2 VERTEXT;
typedef VEC2 VERTEXP;
typedef VEC COLOR;
typedef VEC BRDFMAT;

typedef VERTEX AABOX[2];

typedef struct
{
	char *name;

	// emission
	COLOR e;
	// proprietes pour les differents canaux couleur
	BRDFMAT m;
	BRDFMAT m_sp;
	
	// proprietes de la matiere (+phong)
	float k_du;
	float k_dd;
	float dd_shiny;
	float k_sp;
	
	// textures ??
	// shaders ??
} MATERIAL;

typedef struct
{
	int attr;		// indice du premier attribut
	int n;		// nombre d'attributs

	int mat;		// indice matiere
	int norm;		// indice normale
} FACE;

#define FACE_VERTEX_MORE 4

enum obj_attrib {obj_vertex= 0, obj_tex= 1, obj_norm= 2}; 
enum gl_attrib {gl_tex= 0, gl_norm= 1, gl_vertex= 2}; 

typedef struct 
{
	char *name;		// nom du groupe
	
	int *faces;		// faces declarees dans le groupe
	int faces_size;	
	int faces_n;	// nombre de faces
} GROUP;

#define GROUP_FACE_MORE 10

typedef int ATTR[3];

typedef struct
{
	int flags;
	
	// nom du modele
	char *filename;
	
	// groupes de faces
	GROUP *groups;
	int groups_size;
	int groups_n;
	
	// faces
	FACE *faces;
	int faces_size;
	int faces_n;

	// 
	int *draw_index;
	int draw_index_n;
	
	// liste d'attributs des faces
	ATTR *attr;
	int attr_size;
	int attr_n;
	
	// matieres
	MATERIAL *mat;
	int mat_size;
	int mat_n;
	
	// sommets (coordonnees)
	VERTEX *v;
	int v_size;
	int v_n;
	
	// textures (coordonnees) associees aux sommets
	VERTEXT *tex;
	int tex_size;
	int tex_n;

	// normales aux sommets
	VERTEXN *norm;
	int norm_size;
	int norm_n;
	
	// parametres de surfaces (coordonnees) associees aux sommets
	VERTEXP *param;
	int param_size;
	int param_n;
	
	// proprietes
	AABOX aabox;
} MODEL;

#define MODEL_VERTEX_MORE 100
#define MODEL_FACE_MORE 10
#define MODEL_NORM_MORE 10
#define MODEL_GROUP_MORE 10
#define MODEL_MATERIAL_MORE 10
#define MODEL_ATTR_MORE 100

#define MODEL_HAS_NORM (1<<1)
#define MODEL_HAS_TEX (1<<2)
#define MODEL_IS_CLEAN (1<<3)
#define MODEL_IS_TRIANGLES (1<<4)
#define MODEL_IS_VBO_CLEAN (1<<5)
#define MODEL_HAS_FACES_NORM (1<<6)
#define MODEL_HAS_AABOX (1<<7)

//
extern void array_add(void **parray, int *size, int n, int e_size, int e_more);

//
extern MODEL *model_new(char *filename);
extern void model_free(MODEL *m);

extern int model_is_triangles(MODEL *model);
extern int model_set_triangles(MODEL **model);
extern void model_set_faces_norm(MODEL *model);
extern void model_set_vertex_norm(MODEL *model);

extern void model_set_aabox(MODEL *model);
extern void model_set_scale(MODEL *model, float scale);

extern float model_face_get_area(MODEL *model, int f);

extern void model_print_stat(MODEL *model);

extern void model_display_init(MODEL *model);
extern void model_display(MODEL *model);
extern void model_display_debug(MODEL *model);

extern void model_cull_display(MODEL *model);

//
extern int model_add_face(MODEL *model, int norm, int mat);
extern int model_dup_vertex(MODEL *model, int v);
extern int model_dup_tex(MODEL *model, int t);
extern int model_dup_norm(MODEL *model, int n);

//
extern inline void vertex_copy(VERTEX *d, VERTEX *v);
extern inline void tex_copy(VERTEXT *d, VERTEXT *t);
extern inline void norm_copy(VERTEXN *d, VERTEXN *n);
extern inline void attr_copy(ATTR *d, ATTR *a);
extern inline void mat_copy(MATERIAL *d, MATERIAL *m);

extern void material_free(MATERIAL *m, int n);
extern void face_free(FACE *f, int n);
extern void group_free(GROUP *g, int n);

extern int group_find(MODEL *model, char *name);
extern int material_find(MODEL *model, char *name);

#endif

