#ifndef _MATRIX_H
#define _MATRIX_H

#include "vec.h"

typedef float MAT33[3][3];


extern void mat33_zero(MAT33 a);
extern void mat33_identity(MAT33 m);

extern void mat33_copy(MAT33 m, MAT33 a);
extern inline void mat33_set_row(MAT33 m, int r, float v0, float v1, float v2);

extern inline void mat33_mul(MAT33 m, MAT33 a, MAT33 b);
extern void mat33_mul_vec(VEC v, MAT33 m, VEC u);
extern void mat33_mul_vecT(MAT33 m, VEC u, VEC v);
extern void mat33_const_mul(MAT33 m, float x, MAT33 a);

extern inline void mat33_adj(MAT33 m, MAT33 a);
extern inline float mat33_det(MAT33 a);
extern inline float mat33_inv(MAT33 m, MAT33 a);
extern float mat33_inv_gauss(MAT33 m, MAT33 a);

extern void mat33_print(MAT33 a);

#endif

