/*
	culling
	.  vertex culling
	.  aabox culling
	
	mailto:jciehl@bat710.univ-lyon1.fr
	mars 2006
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <GL/gl.h>

#include "vec.h"
#include "glmat.h"
#include "cull.h"


/* recupere les infos necessaire pour les tests de culling
 */
CULL *cull_set(CULL *cull)
{
	if(cull==NULL)
	{
		cull= (CULL *) malloc(sizeof(CULL));
		assert(cull!=NULL);
	}
	
	glGetFloatv(GL_MODELVIEW_MATRIX, cull->mv);
	glGetFloatv(GL_PROJECTION_MATRIX, cull->p);
	
	glmat_mul(cull->mv, cull->p, cull->mvp);
	// glmat_invert(cull->mvp, cull->mvp_inv);
	
	return cull;
}


/* determine la visibilite d'un sommet
 */
int cull_vertex(CULL *cull, VERTEX v)
{
	GLfloat gv[4];
	GLfloat gvp[4];
	
	gv[0]= v[0];
	gv[1]= v[1];
	gv[2]= v[2];
	gv[3]= 1.f;
	
	glmat_mul_vec(cull->mvp, gv, gvp);
	
	/* un sommet (x y z w) est dans la pyramide de vision si
		-w < x < w
		-w < y < w
		-w < z < w
	 */
	return (gvp[0] < gvp[3] && -gvp[3] < gvp[0]
		&& gvp[1] < gvp[3] && -gvp[3] < gvp[1]
		&& gvp[2] < gvp[3] && -gvp[3] < gvp[2]);
}



/* classification par rapport aux plans de la pyramide de vision
	utilisation :

	cull_set(&info);
	cull_planes_init(&info, planes);
	for(sommets a tester)
		cull_planes_vertex(&info, planes, sommet)
	if(cull_planes(&info, planes))
		le polyhedre defini par les sommets n'est pas visible
 */

void cull_planes_init(CULL *cull, int planes[6])
{
	int i;
	
	for(i= 0; i < 6; i++)
		planes[i]= 0;
}

/* determine la position d'un sommet par rapport aux plans de 
	la pyramide de vision
 */
void cull_planes_vertex(CULL *cull, int planes[6], VERTEX v)
{
	GLfloat gv[4];
	GLfloat gvp[4];
	
	gv[0]= v[0];
	gv[1]= v[1];
	gv[2]= v[2];
	gv[3]= 1.f;
	
	glmat_mul_vec(cull->mvp, gv, gvp);

	// evalue les 6 contraintes
	if(gvp[0] < gvp[3])
		planes[0]++;
	if(-gvp[3] < gvp[0])
		planes[1]++;
	if(gvp[1] < gvp[3])
		planes[2]++;
	if(-gvp[3] < gvp[1])
		planes[3]++;
	if(gvp[2] < gvp[3])
		planes[4]++;
	if(-gvp[3] < gvp[2])
		planes[5]++;
}


/* fin de la classification :
	si un plan rejette tous les sommets testes, il n'y a pas intersection
	et le polyhedre defini par les sommets n'est pas visible
 */
int cull_planes(CULL *cull, int planes[6])
{
	int i;
	
#if 1
	// affiche le nombre de points a l'interieur
	for(i= 0; i < 6; i++)
		printf("%d ", planes[i]);
#endif
	
	for(i= 0; i < 6; i++)
		if(planes[i]==0)
		{
			printf(" culled\n");
			return 1;
		}
	
	printf(" visible\n");
	return 0;
}


/* determine la visibilite d'une aabox
	en utilisant une classification sur les plans de la pyramide de vision
 */
int cull_aabox(CULL *cull, AABOX aabox)
{
	int planes[6];
	VERTEX v;
	int i, p;

	cull_planes_init(cull, planes);
	
	for(i= 0; i < 8; i++)
	{
		// genere les sommets de la boite englobante a partir des extremes
		for(p= 0; p < 3; p++)
		{
			if(i & (1<<p))
				v[p]= aabox[1][p];
			else
				v[p]= aabox[0][p];
		}
		
		// determine l'inclusion du sommet dans la pyramide de vision
		cull_planes_vertex(cull, planes, v);
	}
	
	return cull_planes(cull, planes);
}

