/*
	visu modeles
	
	mailto:jciehl@bat710.univ-lyon1.fr
	
	fevrier 2004
	fevrier 2006
*/

#ifdef _WIN32
#include <windows.h>
#else
#include <unistd.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#include <GL/glut.h>

#include "model.h"
#include "model_clean.h"
#include "maya_obj.h"
#include "vec.h"
#include "view.h"


int main(int argc, char **argv)
{
	char *fname= NULL;
	MODEL *model= NULL;

	/* init et analyse des parametres
	 */	
	srand(time(NULL));

	glutInit(&argc, argv);

	if(argc < 2)
	{
		printf("usage: %s filename.obj\n", argv[0]);
		return 0;
	}

	fname= argv[1];
	if(model_load_obj(&model, fname) < 0)
	{
		printf("\n  -- unable to load model '%s'\n", fname);
		return 1;
	}

	/* prepare le modele pour l'affichage (rapide)
	 */	
	if(model_is_vbo_clean(model)==0)
	{
		printf("model '%s' : forced clean\n", fname);
		model_vbo_clean(&model);
	}
	
	model_display_init(model);
	
	/* visualisation interactive
	 */
	glut_view(model);

	model_free(model);
	return 0;
}
