#ifdef _WIN32
#include <windows.h>
#else
#include <unistd.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#include <GL/glut.h>

#include "model.h"

// globales pour glut
MODEL *scene= NULL;

// timer pour l'animation
int timer;
int timer_rate;


// conversion degres vers radians
float radians(float d)
{
	return d * 0.0174532925;
}

// callback de glut : affichage
void display(void)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glMatrixMode(GL_MODELVIEW); // selectionne la matrice de la scene
	glLoadIdentity(); // reinitialise les transformations

	// oriente la scene par rapport a la camera qui est restee en 0,0,0
	/* A COMPLETER
	 */

	// desssine la scene
	model_display(scene);
	
	// termine l'affichage
	glFlush();

	// echange le buffer de presentation et le buffer d'affichage
	glutSwapBuffers();
}

// callback de glut : appellee regulierement
void anime(void)
{
	// attente
#ifdef _WIN32
	Sleep(1000. / timer_rate);
#else
	usleep(1000000. / timer_rate);
#endif

	timer++;
	
	// demande un nouvel affichage pour la frequence d'animation definie
	glutPostRedisplay();
}

// callback de glut : gestion du clavier (touches speciales)
void keyboard(int key, int x, int y)
{
	int mod;
	
	mod= glutGetModifiers();
	
	switch(key)
	{
		// quitter
		case 27:	// ESC
		case 'q':
		case 'Q':
			exit(0);
			break;

		// navigation
		case GLUT_KEY_UP:
			/* A COMPLETER
			 */
		
			/* pour modifier la vitesse de deplacement, par exemple :
			if(mod&GLUT_ACTIVE_CTRL || mod&GLUT_ACTIVE_ALT)
				// bouge plus vite
			*/
			break;

		case GLUT_KEY_DOWN:
			/* A COMPLETER
			 */
			break;

		case GLUT_KEY_LEFT:
			/* A COMPLETER
			 */
			break;

		case GLUT_KEY_RIGHT:
			/* A COMPLETER
			 */
			break;

		case GLUT_KEY_PAGE_UP:
			/* A COMPLETER
			 */
			break;
		
		case GLUT_KEY_PAGE_DOWN:
			/* A COMPLETER
			 */
			break;
			
		default:
			break;
	}

	// provoque un affichage (appel du callback display)
	glutPostRedisplay();
}

// touches classiques (code ascii) 
void keyboard_char(unsigned char key, int x, int y)
{
	keyboard((int) key, x, y);
}


// mise en place des parametres d'openGL
void initgl(void)
{
	glClearColor(0.0, 0.0, 0.0, 0.0);
	glClearDepth(1.);

	glPolygonMode(GL_FRONT, GL_LINE);
	glPolygonMode(GL_BACK, GL_LINE);
	
	glEnable(GL_DEPTH_TEST);
	// glEnable(GL_CULL_FACE);
	// glCullFace(GL_BACK);

	glMatrixMode(GL_PROJECTION);	// selectionne la matrice de visualisation
	glLoadIdentity();				// reinitialise les transformations

	gluPerspective(50., 1., 1., 10000.);

	// initialise la position et l'orientation de la camera
	/* A COMPLETER
	 */

	timer= 0;
	timer_rate= 50;	// frequence d'affichage
}

void glut_view(MODEL *model)
{
	scene= model;
	
	// creation du contexte d'affichage openGL
	glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize (600, 600);
	// creation de la fenetre assiociee
	glutCreateWindow ("mob");

	// mise en place des parametres d'openGL
	initgl();
	
	/* enregistre les actions pour les evenements :
	*/
	//   clavier (touches standards)
	glutKeyboardFunc(keyboard_char);
	//   clavier (touches speciales, directions, ctrl, alt, etc)
	glutSpecialFunc(keyboard);

	//  affichage
	glutDisplayFunc(display);

	//  animation 
	glutIdleFunc(anime);

	// GO !
	glutMainLoop();
}
