#ifndef _MESH_H
#define _MESH_H

#include "model.h"

typedef struct
{
	int edges[3];
	unsigned char flips[4];
	
	int mat;
} EFACE;

typedef struct
{
	int v[2];
	int attr[2];
} EDGE;

typedef struct
{
	int *data;
	int size;
	int n;
} IDLIST;

typedef IDLIST FLIST;
typedef IDLIST ELIST;

typedef struct
{
	MODEL *model;
	
	EFACE *faces;
	int faces_size;
	int faces_n;
	
	EDGE *edges;
	int edges_size;
	int edges_n;
	
	FLIST *vfaces;
	int vfaces_size;
	int vfaces_n;
	
	ELIST *vedges;
	int vedges_size;
	int vedges_n;
} MESH;

#define MESH_EDGE_MORE (MODEL_FACE_MORE * 2)
#define MESH_FLIST_MORE 4
#define MESH_ELIST_MORE 4


//
extern MESH *mesh_new(MODEL *model);
extern void mesh_free(MESH *mesh);

MODEL *mesh_build_model(MESH *mesh);

extern void mesh_print_stat(MESH *mesh);


#endif

