/*
	visu modeles maya obj 3, ascii
	
	mailto:jciehl@bat710.univ-lyon1.fr
	
	fevrier 2004
*/

#ifdef _WIN32
#include <windows.h>
#else
#include <unistd.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#include <GL/glut.h>

#include "maya_obj.h"
#include "maya_view.h"
#include "vec.h"


// globales pour glut
MODEL *scene;

// position et orientation du point de vue
float camera_x, camera_y, camera_z;
float camera_angle, camera_angle2;
float camera_vitesse;

// timer pour l'animation
int timer;
int timer_rate;


// conversion degres vers radians
float radians(float d)
{
	return d * 0.0174532925;
}

void camera_pref_fname(char *pref, char *scene_fn)
{
	char *ext;

	// construit le nom du fichier de preference pour le modele
	strcpy(pref, scene_fn);
	ext= strrchr(pref, '.');
	if(ext==NULL)
		ext= pref;
	
	strcpy(ext, ".mob");
}

void camera_coller(void)
{
	char pref_fn[1024];
	FILE *in;
	float x, y, z, v, a, b;
	
	camera_pref_fname(pref_fn, scene->filename);
	in= fopen(pref_fn, "rt");
	if(in==NULL)
		return;
	
	if(fscanf(in, "x %f y %f z %f v %f a %f b %f ", &x, &y, &z, &v, &a, &b)==6)
	{
		camera_x= x;
		camera_y= y;
		camera_z= z;
		camera_vitesse= v;
		camera_angle= a;
		camera_angle2= b;
	}
	
	fclose(in);
}

void camera_copier(void)
{
	char pref_fn[1024];
	FILE *out;
	
	camera_pref_fname(pref_fn, scene->filename);

	out= fopen(pref_fn, "wt");
	if(out==NULL)
		return;
	
	fprintf(out, "x %f y %f z %f\nv %f\na %f b %f\n", camera_x, camera_y, camera_z, camera_vitesse, camera_angle, camera_angle2);
	
	fclose(out);
}

// callback de glut : affichage
void display(void)
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glMatrixMode(GL_MODELVIEW);		// selectionne la matrice de la scene
	glLoadIdentity();				// reinitialise les transformations

	// oriente la scene par rapport a la camera qui est restee en 0,0,0
	glRotatef(360. - camera_angle2, 1., 0., 0);
	glRotatef(360. - camera_angle, 0., 1., 0);
	glTranslatef(-camera_x, -camera_y, -camera_z);

	// desssine la scene
	model_display(scene);
	
	// termine l'affichage
    glFlush();
	// echange le buffer de presentation et le buffer d'affichage
    glutSwapBuffers();
}

// callback de glut : appellee regulierement
void anime(void)
{
	// attente
#ifdef _WIN32
	Sleep(1000. / timer_rate);
#else
	usleep(1000000. / timer_rate);
#endif

	timer++;
	
	// demande un nouvel affichage pour la frequence d'animation definie
	glutPostRedisplay();
}

// callback de glut : gestion du clavier (touches speciales)
void keyboard(int key, int x, int y)
{
	int mod;
	
	mod= glutGetModifiers();
	
	switch(key)
	{
		case 27:
		case 'q':
		case 'Q':
			exit(0);
		break;

		case 'c':
			camera_copier();
		break;
		
		case 'v':
			camera_coller();
			glutPostRedisplay();
		break;

		// navigation
		case GLUT_KEY_UP:
			if(mod&GLUT_ACTIVE_CTRL || mod&GLUT_ACTIVE_ALT)
			{
				// rotation de la camera sur X
				camera_angle2+= 1.;
				if(camera_angle2 >= 360.)
					camera_angle2= 0.;
			}
			else
			{
				// deplacement de la camera dans la direction de la visee
				camera_z-= cos(radians(camera_angle)) * camera_vitesse;
				camera_x-= sin(radians(camera_angle)) * camera_vitesse;
			}
		break;

		case GLUT_KEY_DOWN:
			if(mod&GLUT_ACTIVE_CTRL || mod&GLUT_ACTIVE_ALT)
			{
				// rotation de la camera sur Y+
				camera_angle2-= 1.;
				if(camera_angle2 < 0.)
					camera_angle2= 359.;
			}
			else
			{
				// deplacement de la camera dans la direction opposee de la visee
				camera_z+= cos(radians(camera_angle)) * camera_vitesse;
				camera_x+= sin(radians(camera_angle)) * camera_vitesse;
			}
			break;

		case GLUT_KEY_LEFT:
			if(mod&GLUT_ACTIVE_CTRL || mod&GLUT_ACTIVE_ALT)
			{
				// rotation de la camera sur Y-
				camera_angle+= 1.;
				if(camera_angle >= 360.)
					camera_angle= 0.;
			}
			else
			{
				// deplacement perpendiculaire a la direction de visee
				camera_z-= cos(radians(camera_angle + 90.)) * camera_vitesse;
				camera_x-= sin(radians(camera_angle + 90.)) * camera_vitesse;
			}
		break;

		case GLUT_KEY_RIGHT:
			if(mod&GLUT_ACTIVE_CTRL || mod&GLUT_ACTIVE_ALT)
			{
				// rotation de la camera sur Y+
				camera_angle-= 1.;
				if(camera_angle < 0.)
					camera_angle= 359.;
			}
			else
			{
				// deplacement perpendiculaire a la direction de visee
				camera_z-= cos(radians(camera_angle - 90.)) * camera_vitesse;
				camera_x-= sin(radians(camera_angle - 90.)) * camera_vitesse;
			}
		break;

		case GLUT_KEY_PAGE_UP:
			camera_y+= camera_vitesse;
		break;
		
		case GLUT_KEY_PAGE_DOWN:
			camera_y-= camera_vitesse;
		break;
			
		default:
		break;
	}

	// provoque un affichage (appel du callback display)
	glutPostRedisplay();
}

// touches classiques (code ascii) 
void keyboard_char(unsigned char key, int x, int y)
{
	keyboard((int) key, x, y);
}


// mise en place des parametres d'openGL
void initgl(void)
{
    glClearColor(0.0, 0.0, 0.0, 0.0);
	glClearDepth(1.);

	glPolygonMode(GL_FRONT, GL_LINE);
	glPolygonMode(GL_BACK, GL_LINE);
	
	glEnable(GL_DEPTH_TEST);
	// glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);

	
    glMatrixMode(GL_PROJECTION);	// selectionne la matrice de visualisation
    glLoadIdentity();				// reinitialise les transformations

	gluPerspective(50., 1., 1., 1000.);

	camera_x= 0.;
	camera_y= 0.;
	camera_z= 50.;
	camera_angle= 0.;
	camera_vitesse= 10.;

	timer= 0;
	timer_rate= 50;	// frequence d'affichage
}



int main(int argc, char **argv)
{
	int code;
	
	if(argc!=2)
	{
		printf("usage: %s filename.obj\n", argv[0]);
		return 0;
	}

	srand(time(NULL));
	
	code= model_maya_obj(&scene, argv[1]);
	if(code==1)
	{
		// preparation du modele pour le rendu
		model_set_norm(scene);
		
		// affichage openGL
		glutInit(&argc, argv);
		glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
		glutInitWindowSize (600, 600);
		glutInitWindowPosition (100, 100);
		glutCreateWindow ("mob");
		initgl();
		glutKeyboardFunc(keyboard_char);
		glutSpecialFunc(keyboard);
		glutDisplayFunc(display);
		glutIdleFunc(anime);
		glutMainLoop();
	}
	else
		printf("\n  -- unable to load model '%s'\n", argv[1]);


	model_free(scene);
	
	
	return (code==0);
}
