/*
	scenes maya obj 3, ascii
	
	mailto:jciehl@bat710.univ-lyon1.fr
*/

#ifndef _MAYA_OBJ_H
#define _MAYA_OBJ_H

#define ISTOKEN(c) (isalnum(c) || c=='-' || c=='.')

typedef float VEC[4];
typedef VEC VERTEX;
typedef VEC VERTEXN;
typedef VEC VERTEXT;
typedef VEC VERTEXP;
typedef VEC COLOR;
typedef VEC BRDFMAT;

typedef struct
{
	char *name;

	// emission
	COLOR e;
	// proprietes pour les differents canaux couleur
	BRDFMAT m;
	BRDFMAT m_sp;
	
	// proprietes de la matiere (+phong)
	float k_du;
	float k_dd;
	float dd_shiny;
	float k_sp;
	
	// matieres transparentes ?
} MATERIAL;

typedef struct
{
	int mat;		// matiere
	int norm;		// normale
	
	int (*v)[3];	// parametres des sommets
	int size;
	int n;			// nombre de sommets
} FACE;

#define FACE_VERTEX_MORE 3

enum vertex_attrib {vertex= 0, tex= 1, norm= 2};


typedef struct 
{
	char *name;		// nom du groupe
	
	int *faces;		// faces declarees dans le groupe
	int faces_size;	
	int faces_n;	// nombre de faces
} GROUP;

#define GROUP_FACE_MORE 10

typedef struct
{
	// nom du modele
	char *filename;
	
	// groupes de faces
	GROUP *groups;
	int groups_size;
	int groups_n;
	
	// faces
	FACE *faces;
	int faces_size;
	int faces_n;
	
	// matieres
	MATERIAL *mat;
	int mat_size;
	int mat_n;
	
	// sommets (coordonnees)
	VERTEX *v;
	int v_size;
	int v_n;
	
	// normales aux sommets
	VERTEXN *norm;
	int norm_size;
	int norm_n;
	
	// textures (coordonnees) associees aux sommets
	VERTEXT *tex;
	int tex_size;
	int tex_n;
	
	// parametres de surfaces (coordonnees) associees aux sommets
	VERTEXP *param;
	int param_size;
	int param_n;
} MODEL;

#define MODEL_VERTEX_MORE 100
#define MODEL_FACE_MORE 10
#define MODEL_NORM_MORE 10
#define MODEL_GROUP_MORE 10
#define MODEL_MATERIAL_MORE 10

extern void array_add(void **parray, int *size, int n, int e_size, int e_more);

extern int material_find(MODEL *model, char *name);


extern MODEL *model_new(char *filename);
extern void model_free(MODEL *m);

extern int model_maya_obj(MODEL **pmodel, char *filename);
extern void model_display(MODEL *model);
extern void model_set_norm(MODEL *m);


#endif
