/*
	scenes maya obj 3, ascii, triangulees
	
	mailto:jciehl@bat710.univ-lyon1.fr

	fevrier 2004

	fix: a peu plus modulaire ... peu etre
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include <GL/glut.h>

#include "maya_obj.h"
#include "vec.h"

// tableaux dynamiques
void array_add(void **parray, int *size, int n, int e_size, int e_more)
{
	if(n >= *size)
	{
		*size= ((n / e_more) + 1) * e_more;
		
		*parray= realloc(*parray, *size * e_size);
		assert(*parray!=NULL);
	}
}

// gestion des structures
MODEL *model_new(char *filename)
{
	MODEL *m;
	
	m= malloc(sizeof(MODEL));	
	assert(m!=NULL);

#if 0
	char *s, *bs;
	
	s= strrchr(filename, '/');
	bs= strrchr(filename, '\\');
	if(s==NULL && bs!=NULL)
		s= bs;
	
	if(s!=NULL)
		m->filename= strdup(&s[1]);
	else
		m->filename= strdup(filename);

#else
	// fix: permet d'enregistrer les preferences dans le repertoire du modele
	m->filename= strdup(filename);
#endif

	assert(m->filename);
	
	m->groups= NULL;
	m->groups_size= 0;
	m->groups_n= 0;
	
	m->faces= NULL;
	m->faces_size= 0;
	m->faces_n= 0;
	
	m->mat= NULL;
	m->mat_size= 0;
	m->mat_n= 0;
	
	m->v= NULL;
	m->v_size= 0;
	m->v_n= 0;
	
	m->norm= NULL;
	m->norm_size= 0;
	m->norm_n= 0;
	
	m->tex= NULL;
	m->tex_size= 0;
	m->tex_n= 0;
	
	m->param= NULL;
	m->param_size= 0;
	m->param_n= 0;
	
	return m;
}


void material_free(MATERIAL *m, int n)
{
	int i;
	
	if(m==NULL)
		return;
	
	for(i= 0; i<n; i++)
		if(m->name)
			free(m->name);
	
	free(m);
}

void face_free(FACE *f, int n)
{
	int i;
	
	if(f==NULL)
		return;

	for(i= 0; i<n; i++)
		if(f[i].v!=NULL)
			free(f[i].v);

	free(f);
}

void group_free(GROUP *g, int n)
{
	if(g==NULL)
		return;
	
	if(g->name!=NULL)
		free(g->name);
	
	if(g->faces!=NULL)
		free(g->faces);
	
	free(g);		
}

void model_free(MODEL *m)
{
	if(m==NULL)
		return;
	
	if(m->filename!=NULL)
		free(m->filename);

	group_free(m->groups, m->groups_n);
	face_free(m->faces, m->faces_n);
	material_free(m->mat, m->mat_n);

	if(m->v!=NULL)
		free(m->v);
	
	if(m->tex!=NULL)
		free(m->tex);
	
	if(m->norm!=NULL)
		free(m->norm);
	
	if(m->param!=NULL)
		free(m->param);
	
	free(m);
}


// recherches d'elements
int group_find(MODEL *model, char *name)
{
	int i;
	
	for(i= 0; i < model->groups_n; i++)
		if(strcmp(model->groups[i].name, name)==0)
			return i;
	
	return -1;
}

int material_find(MODEL *model, char *name)
{
	int i;
	
	for(i= 0; i < model->mat_n; i++)
		if(strcmp(model->mat[i].name, name)==0)
			return i;
	
	return -1;
}


// lire un mot dans le fichier modele
int get_token(FILE *in, char *tmp, int tmp_size)
{
	char c;
	int i= 0;

	// sauter les blancs
	c= fgetc(in);
	while(c!=EOF && (c==' ' || c=='\t'))
		c= fgetc(in);

	// lire tous les caracteres alphanumeriques
	while(c!=EOF && ISTOKEN(c))
	{
		tmp[i++]= c;
		
		if(i>=tmp_size)
		{
			printf("  -- line length > %d\n", tmp_size);
			return EOF;
		}
		
		c= fgetc(in);
	}

	// separateurs
	if(c=='#')
	{
		if(i==0)
			tmp[i++]= c;
		else
			ungetc(c, in);
	}
	else if(c=='/')
		tmp[i++]= c;
	
	// terminer la chaine
	tmp[i]= 0;

	// indiquer la fin de la ligne ou du fichier
	if(i==0)
		return c;
	
	// forcer une fin de ligne avant la fin du fichier
	if(c==EOF)
		ungetc('\n', in);
		
	else if(c=='\n')
		ungetc(c, in);

	return 0;
}


// lire le fichier modele
int model_maya_obj(MODEL **pmodel, char *filename)
{
	char tmp[1024];

	int* attribs_n[3];
		
	int groups[16];
	int groups_n;
	int g;
	int mat;
	
	MODEL *model;
	GROUP *group;
	FACE *face;
		
	FILE *in;
	int code= 1;

	int i, j;
	int triangles_n, quads_n;
	
	in= fopen(filename, "rt");
	if(in==NULL)
		return 0;
	
	model= model_new(filename);
	
	// attributs en cours de lecture
	attribs_n[vertex]= &model->v_n;
	attribs_n[tex]= &model->tex_n;
	attribs_n[norm]= &model->norm_n;
	groups_n= 0;
	mat= -1;
	
	while(code==1 && get_token(in, tmp, sizeof(tmp))!=EOF)
	{
		// commentaire
		if(strcmp(tmp, "#")==0)
		{
			// lire jusqu'a la fin de la ligne
			while(get_token(in, tmp, sizeof(tmp))!='\n')
				{;}
		}
		
		// groupe ident
		else if(strcmp(tmp, "g")==0 || strcmp(tmp, "s")==0)
		{
			groups_n= 0;
			
			while(get_token(in, tmp, sizeof(tmp))!='\n')
			{
				g= group_find(model, tmp);
				if(g==-1)
				{	
					array_add((void **) &model->groups, &model->groups_size, model->groups_n, sizeof(GROUP), MODEL_GROUP_MORE);
					g= model->groups_n;
					
					model->groups[model->groups_n].name= strdup(tmp);
					assert(model->groups!=NULL);
					model->groups[model->groups_n].faces= NULL;
					model->groups[model->groups_n].faces_size= 0;
					model->groups[model->groups_n].faces_n= 0;
					model->groups_n++;
				}
				
				// groups[groups_n++]= g;
				groups[0]= g;
				groups_n= 1;
				
				assert(groups_n < 16);
			}
		}
		
		// matiere ident
		else if(strcmp(tmp, "usemtl")==0)
		{
			get_token(in, tmp, sizeof(tmp));

			mat= material_find(model, tmp);
			if(mat==-1)
			{
				array_add((void **) &model->mat, &model->mat_size, model->mat_n, sizeof(MATERIAL), MODEL_MATERIAL_MORE);
				mat= model->mat_n;
				
				model->mat[model->mat_n].name= strdup(tmp);
				
				model->mat_n++;
			}
		}
		
		// vertex x y z [w]
		else if(strcmp(tmp, "v")==0)
		{
			array_add((void **) &model->v, &model->v_size, model->v_n, sizeof(VERTEX), MODEL_VERTEX_MORE);
			
			for(i= 0; get_token(in, tmp, sizeof(tmp))!='\n'; i++)
				if(i<3 && sscanf(tmp, "%f", &model->v[model->v_n][i])==0)
				{
					printf(" -- missing value\n");
					code= 0;
					break;
				}

			for(; i<3; i++)
				model->v[model->v_n][i]= 0.;
			
			model->v_n++;
		}
		
		// vertex param 
		else if(strcmp(tmp, "vp")==0)
		{
			array_add((void **) &model->param, &model->param_size, model->param_n, sizeof(VERTEXP), MODEL_VERTEX_MORE);
			
			for(i= 0; get_token(in, tmp, sizeof(tmp))!='\n'; i++)
				if(i<3 && sscanf(tmp, "%f", &model->param[model->param_n][i])==0)
				{
					printf(" -- missing value\n");
					code= 0;
					break;
				}
			
			for(; i<3; i++)
				model->param[model->param_n][i]= 0.;
			
			model->param_n++;
		}
		
		// vertex normal
		else if(strcmp(tmp, "vn")==0)
		{
			array_add((void **) &model->norm, &model->norm_size, model->norm_n, sizeof(VERTEXN), MODEL_VERTEX_MORE);
			
			for(i= 0; get_token(in, tmp, sizeof(tmp))!='\n'; i++)
				if(i<3 && sscanf(tmp, "%f", &model->norm[model->norm_n][i])==0)
				{
					printf(" -- missing value\n");
					code= 0;
					break;
				}
		
			for(; i<3; i++)
				model->norm[model->norm_n][i]= 0.;
			
			model->norm_n++;
		}

		// vertex texture
		else if(strcmp(tmp, "vt")==0)
		{
			array_add((void **) &model->tex, &model->tex_size, model->tex_n, sizeof(VERTEXT), MODEL_VERTEX_MORE);
			
			for(i= 0; get_token(in, tmp, sizeof(tmp))!='\n'; i++)
				if(i<3 && sscanf(tmp, "%f", &model->tex[model->tex_n][i])==0)
				{
					printf(" -- missing value\n");
					code= 0;
					break;
				}

			for(; i<3; i++)
				model->tex[model->tex_n][i]= 0.;
			
			model->tex_n++;
		}
		
		// face
		else if(strcmp(tmp, "f")==0)
		{
			array_add((void **) &model->faces, &model->faces_size, model->faces_n, sizeof(FACE), MODEL_FACE_MORE);
			
			face= &model->faces[model->faces_n];
			face->norm= -1;
			face->mat= mat;
			assert(mat!=-1);
			face->n= 0;
			face->size= 0;
			face->v= NULL;

			for(i= 0; get_token(in, tmp, sizeof(tmp))!='\n'; i++)
			{
				array_add((void **) &face->v, &face->size, face->n, sizeof(int [3]), FACE_VERTEX_MORE);
				face->v[face->n][vertex]= -1;
				face->v[face->n][tex]= -1;
				face->v[face->n][norm]= -1;
				
				// lecture des parametres des sommets
				j= 0;
				do
				{
					if(j<3 && strcmp(tmp, "/")!=0)
					{
						if(sscanf(tmp, "%d", &face->v[face->n][j])==0)
						{
							printf("  -- missing value\n");
							code= 0;
							break;
						}
						
						if(face->v[face->n][j] < 0)
						{
							// printf("index %d, value %d = %d\n", *attribs_n[j], face->v[face->n][j], *attribs_n[j] + face->v[face->n][j]);
							face->v[face->n][j]= *attribs_n[j] + face->v[face->n][j];
						}
						else
							face->v[face->n][j]-= 1;
							
						if(face->v[face->n][j] < 0  ||  face->v[face->n][j] >= *attribs_n[j])
						{
							printf("  -- wrong attribute index\n");
							code= 0;
							break;
						}
					}
					j++;
				}
				while(tmp[strlen(tmp) -1]=='/' && get_token(in, tmp, sizeof(tmp))!='\n');

				face->n++;
			}
			
			// ajouter la face aux groupes courants
			for(g= 0; g<groups_n; g++)
			{
				group= &model->groups[groups[g]];
				array_add((void **) &group->faces, &group->faces_size, group->faces_n, sizeof(int), GROUP_FACE_MORE);
				group->faces[group->faces_n++]= model->faces_n;
			}
			
			model->faces_n++;
		}
	}
	
	fclose(in);

	printf("model %s: %d(%d) groups, %d(%d) faces, %d(%d) vertices\n", 
		model->filename, 
		model->groups_n, model->groups_size, 
		model->faces_n, model->faces_size, 
		model->v_n, model->v_size);

	triangles_n= 0;
	quads_n= 0;
	for(i= 0; i<model->faces_n; i++)
	{
		if(model->faces[i].n==3)
			triangles_n++;
		else if(model->faces[i].n==4)
			quads_n++;
	}
	
	printf("%d triangles, %d quads\n", triangles_n, quads_n);
	
	printf("materials %d(%d):\n", model->mat_n, model->mat_size);
	for(i= 0; i<model->mat_n; i++)
		printf("  %s\n", model->mat[i].name);
	
	*pmodel= model;
	return code;
}

// ajoute les normales associees aux faces dans le modele
void model_set_norm(MODEL *m)
{
	int i;
	VEC u, v;
	
	array_add((void **) &m->norm, &m->norm_size, m->norm_n + m->faces_n -1, sizeof(VERTEXN), MODEL_NORM_MORE);
	
	for(i= 0; i<m->faces_n; i++)
	{
		m->faces[i].norm= m->norm_n;
		
		vec3_sub(u, m->v[m->faces[i].v[1][vertex]],                m->v[m->faces[i].v[0][vertex]]);
		vec3_sub(v, m->v[m->faces[i].v[m->faces[i].n -1][vertex]], m->v[m->faces[i].v[0][vertex]]);
		
		vec3_cross(m->norm[m->norm_n], u, v);
		vec3_norm(m->norm[m->norm_n], m->norm[m->norm_n]);
		
		m->norm_n++;
	}
}



// affichage du modele maya
void model_display(MODEL *model)
{
	int (*iv)[3];
	int i;

	glLineWidth(1.);
	for(i= 0; i<model->faces_n; i++)
	{
		iv= model->faces[i].v;
		
		if(strcmp(model->mat[model->faces[i].mat].name, "diffuseLuminaire1SG")==0)
			// sources de lumieres en jaune
			glColor3f(.5, .5, 0.);
		else
			// objets en blanc
			glColor3f(.5, .5, .5);

		if(model->faces[i].n==3)
		{
			// glBegin(GL_LINE_LOOP);
			glBegin(GL_TRIANGLES);
			
			glNormal3fv(model->norm[model->faces[i].norm]);
			
			glVertex3fv(model->v[iv[0][vertex]]);
			glVertex3fv(model->v[iv[1][vertex]]);
			glVertex3fv(model->v[iv[2][vertex]]);
			glEnd();
		}
		else if(model->faces[i].n==4)
		{
			// glBegin(GL_LINE_LOOP);
			glBegin(GL_QUADS);

			glNormal3fv(model->norm[model->faces[i].norm]);

			glVertex3fv(model->v[iv[0][vertex]]);
			glVertex3fv(model->v[iv[1][vertex]]);
			glVertex3fv(model->v[iv[2][vertex]]);
			glVertex3fv(model->v[iv[3][vertex]]);
			glEnd();
		}
	}
}

