/*
	camera elementaire

	mailto:jciehl@bat710.univ-lyon1.fr
 */

#include <stdlib.h>
#include <assert.h>

#include <math.h>

#include "vec.h"

// camera pseudo-openGL
CAMERA *camera_locale(float fov, int largeur, int hauteur)
{
	CAMERA *camera= (CAMERA *) malloc(sizeof(CAMERA));
	
	assert(camera!=NULL);
	
	camera->largeur= largeur;
	camera->hauteur= hauteur;
	
	/* determiner A et B d'apres fov, pour s=1, 
	   seuls u= (Bu-Au) et v= (Bv-Av) sont necessaires, A==(-u/2, -v/2) et B==(u/2, v/2)
	 */
	
	camera->u= 2.* sin(radians(fov));
	camera->v= 2.* sin(radians(fov));

	camera->E[0]= 0.;
	camera->E[1]= 0.;
	camera->E[2]= 0.;
	
	camera->W[0]= 0.;
	camera->W[1]= 0.;
	camera->W[2]= 1.;
	
	camera->U[0]= 1.;
	camera->U[1]= 0.;
	camera->U[2]= 0.;
	
	camera->V[0]= 0.;
	camera->V[1]= 1.;
	camera->V[2]= 0.;

	return camera;
}

// genere un rayon pour le pixel (x, y) dans le repere de la scene
void camera_rayon(CAMERA *camera, float x, float y, float origine[3], float direction[3])
{
	float u, v, w;

	// origine: repere de la scene
	vec3_copy(origine, camera->E);
	
	// direction: repere local UVW
	u= -camera->u / 2. + camera->u * x / (float) (camera->largeur -1);
	v= -camera->v / 2. + camera->v * y / (float) (camera->hauteur -1);
	w= -1.;
	
	// direction: repere de la scene
	vec3_const_mul(direction, u, camera->U);
	vec3_add_mul_const(direction, direction, v, camera->V);
	vec3_add_mul_const(direction, direction, w, camera->W);

	// normalisation de la direction
	vec3_norm(direction, direction);
}

