/*
	lancer de rayons recursif
	
	matieres opaques
 */

#include <stdlib.h>

#include "struct.h"
#include "source.h"
#include "visu.h"
#include "matiere.h"
#include "vec.h"


// calcule l'eclairement direct en un point
void whitted_eclairement_direct(CSG *scene, LISTE_SOURCE *sources, INTER *inter, float point[3], float direction[3], float couleur[3])
{
	LISTE_INTER inter_ombre;
	
	float v[3], v_refl[3], n[3];
	float source_couleur[3];
	float ombre_direction[3];
	float ombre_poids;
	float r;
	
	int code;
	int s, i;
	int rayons_n;

	// recuperer la normale au point d'intersection 
	vec3_copy(n, inter->n);

	if(sources==NULL)
	{
		// source de lumiere (par defaut) au centre de projection
		vec3_neg(v, direction);
		
		// calculer la couleur du pixel
		r= vec3_dot(n, v);
		if(r > EPSILON)
		{
			couleur[0]= r * inter->r;
			couleur[1]= r * inter->g;
			couleur[2]= r * inter->b;
		}
		
		return;
	}

	//
	inter_ombre.data= NULL;
	inter_ombre.n= 0;
	inter_ombre.size= 0;

	// generer la direction reflechie 
	miroir_rayon(inter->matiere, direction, n, v_refl);

	// lancer un rayon d'ombre pour chaque source
	couleur[0]= 0.; couleur[1]= 0.; couleur[2]= 0.;
	for(s= 0; s<sources->n; s++)
	{
		if(sources->data[s].type==src_point)
			rayons_n= 1;
		else
			rayons_n= SOURCE_ECHANTILLONS_N;
	
		vec3_zero(source_couleur);		
		for(i= 0; i<rayons_n; i++)
		{
			// generer le rayon d'ombre
			sources->data[s].rayon_ombre(&sources->data[s], point, ombre_direction, &ombre_poids);
		
			// lancer le rayon d'ombre, si necessaire
			vec3_norm(v, ombre_direction);

			// calculer la contribution de la lumiere au point, selon la matiere associee
			r= vec3_dot(n, v) * inter->matiere->k_du
				+ pow(vec3_dot(v_refl, v), inter->matiere->dd_n) * inter->matiere->k_dd
				+ pow(vec3_dot(v_refl, v), 512.) * inter->matiere->k_sp;
				
			if(r > EPSILON)
			{
				inter_ombre.n= 0;
				code= 0;

				if(scene->type==csg_primitive)
					code= scene->noeud.primitive->intersection(scene->noeud.primitive, &inter_ombre, point, ombre_direction);
				else if(scene->type==csg_bool)
					code= scene->noeud.operation->intersection(scene->noeud.operation, &inter_ombre, point, ombre_direction);
			
				// tester l'occlusion de la source
				if(code==0 || !(code > 0 && inter_ombre.data[0][inter_entree].t > .0 && inter_ombre.data[0][inter_sortie].t < 1.))
				{
					source_couleur[0]+= r * inter->r * sources->data[s].r;
					source_couleur[1]+= r * inter->g * sources->data[s].g;
					source_couleur[2]+= r * inter->b * sources->data[s].b;
				}
			}
			
			if(inter->matiere->k_du > EPSILON)
			{
				// ajoute un terme ambiant sur les matieres diffuses (pour eviter les ombres completement noires)
				source_couleur[0]+= inter->r * sources->data[s].ar;
				source_couleur[1]+= inter->g * sources->data[s].ag;
				source_couleur[2]+= inter->b * sources->data[s].ab;
			}
		}

		r= 1. / (float) rayons_n;
		vec3_add_mul_const(couleur, couleur, r, source_couleur);
	}

	if(inter_ombre.data!=NULL)
		free(inter_ombre.data);
}



// lancer de rayon recursif sur objets opaques
// profondeur limitee
int rayon_whitted_opaque(CSG *scene, LISTE_SOURCE *sources, float origine[3], float direction[3], float couleur[3], int profondeur)
{
	LISTE_INTER inter;

	float miroir_couleur[3];
	float v_refl[3];
	float p[3];
	float n[3];
	float r;
	
	int code;

	//	
	couleur[0]= 0.; couleur[1]= 0.; couleur[2]= 0.;
	if(profondeur > WHITTED_PROFONDEUR)
		return 0;
	
	//
	inter.data= NULL;
	inter.n= 0;
	inter.size= 0;
	
	// determiner quel est l'objet visible == intersection du rayon et de la scene
	code= 0;
	if(scene->type==csg_primitive)
		code= scene->noeud.primitive->intersection(scene->noeud.primitive, &inter, origine, direction);
	else if(scene->type==csg_bool)
		code= scene->noeud.operation->intersection(scene->noeud.operation, &inter, origine, direction);

	if(code>0 && inter.data[0][inter_entree].t > 0.)
	{
		// calculer la position du point d'intersection
		vec3_add_mul_const(p, origine, inter.data[0][inter_entree].t, direction);

		// recuperer la normale au point d'intersection 
		vec3_copy(n, inter.data[0][inter_entree].n);

		// decaler le point d'intersection le long de la normale
		vec3_add_mul_const(p, p, EPSILON, n);

		/// calcul de l'eclairement direct
		whitted_eclairement_direct(scene, sources, &inter.data[0][inter_entree], p, direction, couleur);
	
		// detecter les matieres qui necessitent de lancer des rayons supplementaires (miroir, objets transparents ...)
		if(inter.data[0][inter_entree].matiere->k_sp > EPSILON)
		{
			// generer la direction reflechie 
			miroir_rayon(inter.data[0][inter_entree].matiere, direction, n, v_refl);

			// lancer un rayon supplementaire
			rayon_whitted_opaque(scene, sources, p, v_refl, miroir_couleur, profondeur +1);

			// ajouter la couleur
			r= inter.data[0][inter_entree].matiere->k_sp + (1. - inter.data[0][inter_entree].matiere->k_sp) * pow(1. + vec3_dot(n, direction), 5.);
			vec3_add_mul_const(couleur, couleur, r, miroir_couleur);
		}
	}

	if(inter.data!=NULL)
		free(inter.data);
	
	return 1;
}

